/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.vmplugin.v8;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.groovy.util.SystemUtil;
import org.codehaus.groovy.runtime.memoize.LRUCache;
import org.codehaus.groovy.runtime.memoize.MemoizeCache;
import org.codehaus.groovy.vmplugin.v8.MethodHandleWrapper;

public class CacheableCallSite
extends MutableCallSite {
    private static final int CACHE_SIZE = SystemUtil.getIntegerSafe("groovy.indy.callsite.cache.size", 16);
    private final MemoizeCache<String, MethodHandleWrapper> cache = new LRUCache<String, MethodHandleWrapper>(CACHE_SIZE);
    private volatile MethodHandleWrapper latestHitMethodHandleWrapper = null;
    private final AtomicLong fallbackCount = new AtomicLong(0L);
    private MethodHandle defaultTarget;
    private MethodHandle fallbackTarget;

    public CacheableCallSite(MethodType type) {
        super(type);
    }

    public MethodHandleWrapper getAndPut(String className, MemoizeCache.ValueProvider<? super String, ? extends MethodHandleWrapper> valueProvider) {
        MethodHandleWrapper lhmh = this.latestHitMethodHandleWrapper;
        MethodHandleWrapper result = this.cache.getAndPut(className, valueProvider);
        if (lhmh == result) {
            result.incrementLatestHitCount();
        } else {
            result.resetLatestHitCount();
            if (null != lhmh) {
                lhmh.resetLatestHitCount();
            }
            this.latestHitMethodHandleWrapper = result;
        }
        return result;
    }

    public MethodHandleWrapper put(String name, MethodHandleWrapper mhw) {
        return this.cache.put(name, mhw);
    }

    public long incrementFallbackCount() {
        return this.fallbackCount.incrementAndGet();
    }

    public void resetFallbackCount() {
        this.fallbackCount.set(0L);
    }

    public MethodHandle getDefaultTarget() {
        return this.defaultTarget;
    }

    public void setDefaultTarget(MethodHandle defaultTarget) {
        this.defaultTarget = defaultTarget;
    }

    public MethodHandle getFallbackTarget() {
        return this.fallbackTarget;
    }

    public void setFallbackTarget(MethodHandle fallbackTarget) {
        this.fallbackTarget = fallbackTarget;
    }
}

