/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.dialogs;

import gen.core.project.RepositoryDefinition;
import gen.core.project.RepositoryMapping;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import java.util.stream.Stream;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.AbstractTableModel;
import org.omegat.gui.dialogs.RepositoriesMappingDialog;
import org.omegat.util.OStrings;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.DelegatingComboBoxRenderer;
import org.omegat.util.gui.StaticUIUtils;
import org.omegat.util.gui.TableColumnSizer;

public class RepositoriesMappingController {
    private List<RepositoryDefinition> result;
    private RepositoriesMappingDialog dialog;
    private AbstractTableModel modelRepo;
    private List<RowRepo> listRepo;
    private AbstractTableModel modelMapping;
    private List<RowMapping> listMapping;
    private TableColumnSizer repoSizer;
    private TableColumnSizer mappingSizer;

    public List<RepositoryDefinition> show(Frame parent, List<RepositoryDefinition> input) {
        this.dialog = new RepositoriesMappingDialog(parent, true);
        this.dialog.setLocationRelativeTo(parent);
        this.dialog.getRootPane().setDefaultButton(this.dialog.okButton);
        StaticUIUtils.setEscapeClosable(this.dialog);
        this.listRepo = new ArrayList<RowRepo>();
        this.listMapping = new ArrayList<RowMapping>();
        this.putData(input);
        this.initTableModels();
        this.initButtons();
        this.reinitRepoUrlDropdown();
        this.dialog.tableRepositories.getSelectionModel().addListSelectionListener(e -> this.updateState());
        this.dialog.tableMapping.getSelectionModel().addListSelectionListener(e -> this.updateState());
        this.dialog.tableRepositories.getModel().addTableModelListener(e -> this.updateState());
        this.repoSizer = TableColumnSizer.autoSize(this.dialog.tableRepositories, 1, true);
        this.mappingSizer = TableColumnSizer.autoSize(this.dialog.tableMapping, 0, true);
        this.updateState();
        this.dialog.setVisible(true);
        return this.result;
    }

    private void updateState() {
        this.dialog.btnRepoRemove.setEnabled(this.dialog.tableRepositories.getSelectedRow() != -1);
        this.dialog.btnMappingRemove.setEnabled(this.dialog.tableMapping.getSelectedRow() != -1);
        this.dialog.btnMappingAdd.setEnabled(this.dialog.tableRepositories.getRowCount() > 0);
    }

    void initTableModels() {
        this.modelRepo = new AbstractTableModel(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                if (rowIndex >= RepositoriesMappingController.this.listRepo.size()) {
                    return null;
                }
                RowRepo r = RepositoriesMappingController.this.listRepo.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return r.type == null ? null : r.type.getLocalizedString();
                    }
                    case 1: {
                        return r.url;
                    }
                }
                return null;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                RowRepo r = RepositoriesMappingController.this.listRepo.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        r.type = (RepoType)((Object)aValue);
                        break;
                    }
                    case 1: {
                        String old = r.url;
                        r.url = (String)aValue;
                        RepositoriesMappingController.this.changeRepoUrl(old, r.url);
                        RepositoriesMappingController.this.reinitRepoUrlDropdown();
                    }
                }
                RepositoriesMappingController.this.repoSizer.reset();
                RepositoriesMappingController.this.repoSizer.adjustTableColumns();
            }

            @Override
            public int getRowCount() {
                return RepositoriesMappingController.this.listRepo.size();
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return true;
            }

            @Override
            public String getColumnName(int column) {
                switch (column) {
                    case 0: {
                        return OStrings.getString("RMD_TABLE_REPOSITORIES_TYPE");
                    }
                    case 1: {
                        return OStrings.getString("RMD_TABLE_REPOSITORIES_URL");
                    }
                }
                return null;
            }
        };
        this.dialog.tableRepositories.setModel(this.modelRepo);
        JComboBox<RepoType> comboBox = new JComboBox<RepoType>(RepoType.values());
        comboBox.setRenderer((ListCellRenderer<RepoType>)new DelegatingComboBoxRenderer<RepoType, String>(){

            @Override
            protected String getDisplayText(RepoType value) {
                return value == null ? "" : value.getLocalizedString();
            }
        });
        this.dialog.tableRepositories.getColumnModel().getColumn(0).setCellEditor(new DefaultCellEditor(comboBox));
        this.modelMapping = new AbstractTableModel(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                if (rowIndex >= RepositoriesMappingController.this.listMapping.size()) {
                    return null;
                }
                RowMapping r = RepositoriesMappingController.this.listMapping.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return r.repoUrl;
                    }
                    case 1: {
                        return r.local;
                    }
                    case 2: {
                        return r.remote;
                    }
                    case 3: {
                        return r.excludes;
                    }
                    case 4: {
                        return r.includes;
                    }
                }
                return null;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                RowMapping r = RepositoriesMappingController.this.listMapping.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        r.repoUrl = (String)aValue;
                        break;
                    }
                    case 1: {
                        r.local = (String)aValue;
                        break;
                    }
                    case 2: {
                        r.remote = (String)aValue;
                        break;
                    }
                    case 3: {
                        r.excludes = (String)aValue;
                        break;
                    }
                    case 4: {
                        r.includes = (String)aValue;
                    }
                }
                RepositoriesMappingController.this.mappingSizer.reset();
                RepositoriesMappingController.this.mappingSizer.adjustTableColumns();
            }

            @Override
            public int getRowCount() {
                return RepositoriesMappingController.this.listMapping.size();
            }

            @Override
            public int getColumnCount() {
                return 5;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return true;
            }

            @Override
            public String getColumnName(int column) {
                switch (column) {
                    case 0: {
                        return OStrings.getString("RMD_TABLE_MAPPING_REPO");
                    }
                    case 1: {
                        return OStrings.getString("RMD_TABLE_MAPPING_LOCAL");
                    }
                    case 2: {
                        return OStrings.getString("RMD_TABLE_MAPPING_REMOTE");
                    }
                    case 3: {
                        return OStrings.getString("RMD_TABLE_MAPPING_EXCLUDES");
                    }
                    case 4: {
                        return OStrings.getString("RMD_TABLE_MAPPING_INCLUDES");
                    }
                }
                return null;
            }
        };
        this.dialog.tableMapping.setModel(this.modelMapping);
    }

    void initButtons() {
        this.dialog.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RepositoriesMappingController.this.dialog.dispose();
            }
        });
        this.dialog.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean doneEditing = Stream.of(RepositoriesMappingController.this.dialog.tableMapping, RepositoriesMappingController.this.dialog.tableRepositories).map(JTable::getCellEditor).allMatch(editor -> editor == null || editor.stopCellEditing());
                if (!doneEditing) {
                    return;
                }
                String r = RepositoriesMappingController.this.isValid();
                if (r != null) {
                    JOptionPane.showMessageDialog(RepositoriesMappingController.this.dialog, r, OStrings.getString("TF_ERROR"), 0);
                    return;
                }
                RepositoriesMappingController.this.result = RepositoriesMappingController.this.getData();
                RepositoriesMappingController.this.dialog.dispose();
            }
        });
        this.dialog.btnRepoAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RepositoriesMappingController.this.listRepo.add(new RowRepo());
                int row = RepositoriesMappingController.this.listRepo.size() - 1;
                RepositoriesMappingController.this.modelRepo.fireTableRowsInserted(row, row);
                RepositoriesMappingController.this.dialog.tableRepositories.setRowSelectionInterval(row, row);
            }
        });
        this.dialog.btnRepoRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int r = RepositoriesMappingController.this.dialog.tableRepositories.getSelectedRow();
                if (r >= 0) {
                    RepositoriesMappingController.this.listRepo.remove(r);
                    RepositoriesMappingController.this.modelRepo.fireTableRowsDeleted(r, r);
                }
            }
        });
        this.dialog.btnMappingAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RowMapping mapping = new RowMapping();
                if (RepositoriesMappingController.this.dialog.tableRepositories.getRowCount() == 1) {
                    mapping.repoUrl = (String)RepositoriesMappingController.this.dialog.tableRepositories.getValueAt(0, 1);
                }
                RepositoriesMappingController.this.listMapping.add(mapping);
                int row = RepositoriesMappingController.this.listMapping.size() - 1;
                RepositoriesMappingController.this.modelMapping.fireTableRowsInserted(row, row);
                RepositoriesMappingController.this.dialog.tableMapping.setRowSelectionInterval(row, row);
            }
        });
        this.dialog.btnMappingRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int r = RepositoriesMappingController.this.dialog.tableMapping.getSelectedRow();
                if (r >= 0) {
                    RepositoriesMappingController.this.listMapping.remove(r);
                    RepositoriesMappingController.this.modelMapping.fireTableRowsDeleted(r, r);
                }
            }
        });
    }

    void changeRepoUrl(String oldUrl, String newUrl) {
        if (oldUrl == null) {
            return;
        }
        for (int i = 0; i < this.listMapping.size(); ++i) {
            if (!oldUrl.equals(this.listMapping.get((int)i).repoUrl)) continue;
            this.listMapping.get((int)i).repoUrl = newUrl;
            this.modelMapping.fireTableCellUpdated(i, 0);
        }
    }

    void reinitRepoUrlDropdown() {
        JComboBox<String> comboBox = new JComboBox<String>();
        for (RowRepo r : this.listRepo) {
            comboBox.addItem(r.url);
        }
        this.dialog.tableMapping.getColumnModel().getColumn(0).setCellEditor(new DefaultCellEditor(comboBox));
    }

    String isValid() {
        TreeSet<String> urls = new TreeSet<String>();
        for (RowRepo rowRepo : this.listRepo) {
            if (StringUtil.isEmpty(rowRepo.url)) {
                return OStrings.getString("RMD_INVALID_BLANK_REPO");
            }
            if (rowRepo.type == null) {
                return MessageFormat.format(OStrings.getString("RMD_INVALID_REPO_TYPE"), new Object[]{rowRepo.type});
            }
            if (urls.add(rowRepo.url)) continue;
            return MessageFormat.format(OStrings.getString("RMD_INVALID_DUPLICATE_REPO"), rowRepo.url);
        }
        for (RowMapping rowMapping : this.listMapping) {
            if (StringUtil.isEmpty(rowMapping.repoUrl)) {
                return OStrings.getString("RMD_INVALID_BLANK_REPO");
            }
            if (urls.contains(rowMapping.repoUrl)) continue;
            return MessageFormat.format(OStrings.getString("RMD_INVALID_UNKNOWN_REPO"), rowMapping.repoUrl);
        }
        return null;
    }

    void putData(List<RepositoryDefinition> data) {
        if (data == null) {
            return;
        }
        for (RepositoryDefinition rd : data) {
            RowRepo r = new RowRepo();
            r.type = RepoType.valueOf(rd.getType().toUpperCase(Locale.ENGLISH));
            r.url = rd.getUrl();
            this.listRepo.add(r);
            for (RepositoryMapping rm : rd.getMapping()) {
                RowMapping m = new RowMapping();
                m.repoUrl = rd.getUrl();
                m.local = this.normalizeMapping(rm.getLocal());
                m.remote = this.normalizeMapping(rm.getRepository());
                m.excludes = String.join((CharSequence)";", rm.getExcludes());
                m.includes = String.join((CharSequence)";", rm.getIncludes());
                this.listMapping.add(m);
            }
        }
    }

    List<RepositoryDefinition> getData() {
        ArrayList<RepositoryDefinition> result = new ArrayList<RepositoryDefinition>();
        for (RowRepo r : this.listRepo) {
            RepositoryDefinition rd = new RepositoryDefinition();
            rd.setType(r.type.name().toLowerCase(Locale.ENGLISH));
            rd.setUrl(r.url);
            result.add(rd);
            for (RowMapping m : this.listMapping) {
                if (!r.url.equals(m.repoUrl)) continue;
                RepositoryMapping rm = new RepositoryMapping();
                rm.setLocal(this.normalizeMapping(m.local));
                rm.setRepository(this.normalizeMapping(m.remote));
                if (!StringUtil.isEmpty(m.excludes)) {
                    rm.getExcludes().addAll(Arrays.asList(m.excludes.trim().split(";")));
                }
                if (!StringUtil.isEmpty(m.includes)) {
                    rm.getIncludes().addAll(Arrays.asList(m.includes.trim().split(";")));
                }
                rd.getMapping().add(rm);
            }
        }
        return result;
    }

    String normalizeMapping(String mapping) {
        return StringUtil.isEmpty(mapping) ? "/" : mapping;
    }

    static class RowMapping {
        public String repoUrl;
        public String local = "/";
        public String remote = "/";
        public String excludes;
        public String includes;

        RowMapping() {
        }
    }

    static class RowRepo {
        public RepoType type;
        public String url;

        RowRepo() {
        }
    }

    static enum RepoType {
        GIT,
        SVN,
        HTTP,
        FILE;


        public String getLocalizedString() {
            return OStrings.getString("RMD_TABLE_REPO_TYPE_" + this.name());
        }
    }
}

