/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.omegat.core.data.EntryKey;
import org.omegat.core.data.ProtectedPart;
import org.omegat.core.data.SegmentProperties;

public class SourceTextEntry {
    private static final ProtectedPart[] EMPTY_PROTECTED_PARTS = new ProtectedPart[0];
    private final EntryKey key;
    private final String[] props;
    private final String sourceTranslation;
    private boolean sourceTranslationFuzzy;
    private boolean paragraphStart;
    List<SourceTextEntry> duplicates;
    SourceTextEntry firstInstance;
    private final int m_entryNum;
    private final ProtectedPart[] protectedParts;

    public SourceTextEntry(EntryKey key, int entryNum, String[] props, String sourceTranslation, List<ProtectedPart> protectedParts, boolean paragraphStart) {
        this.key = key;
        this.m_entryNum = entryNum;
        this.props = props;
        this.sourceTranslation = sourceTranslation;
        this.paragraphStart = paragraphStart;
        if (protectedParts.isEmpty()) {
            this.protectedParts = EMPTY_PROTECTED_PARTS;
        } else {
            for (int i = 0; i < protectedParts.size(); ++i) {
                if (!protectedParts.get(i).getTextInSourceSegment().isEmpty()) continue;
                protectedParts.remove(i);
                --i;
            }
            this.protectedParts = protectedParts.toArray(new ProtectedPart[protectedParts.size()]);
        }
        this.duplicates = null;
        this.firstInstance = null;
    }

    public SourceTextEntry(EntryKey key, int entryNum, String[] props, String sourceTranslation, List<ProtectedPart> protectedParts) {
        this(key, entryNum, props, sourceTranslation, protectedParts, true);
    }

    public EntryKey getKey() {
        return this.key;
    }

    public String getSrcText() {
        return this.key.sourceText;
    }

    public String getComment() {
        if (SegmentProperties.isEmpty(this.props)) {
            return null;
        }
        return SegmentProperties.joinValues(this.props);
    }

    public String[] getRawProperties() {
        return SegmentProperties.copy(this.props);
    }

    public int entryNum() {
        return this.m_entryNum;
    }

    public DUPLICATE getDuplicate() {
        if (this.firstInstance != null) {
            return DUPLICATE.NEXT;
        }
        return this.duplicates == null ? DUPLICATE.NONE : DUPLICATE.FIRST;
    }

    public int getNumberOfDuplicates() {
        if (this.firstInstance != null) {
            return this.firstInstance.getNumberOfDuplicates();
        }
        return this.duplicates == null ? 0 : this.duplicates.size();
    }

    public List<SourceTextEntry> getDuplicates() {
        if (this.firstInstance != null) {
            ArrayList<SourceTextEntry> result = new ArrayList<SourceTextEntry>(this.firstInstance.getDuplicates());
            result.remove(this);
            result.add(0, this.firstInstance);
            return Collections.unmodifiableList(result);
        }
        if (this.duplicates == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.duplicates);
    }

    public String getSourceTranslation() {
        return this.sourceTranslation;
    }

    public boolean isSourceTranslationFuzzy() {
        return this.sourceTranslationFuzzy;
    }

    public void setSourceTranslationFuzzy(boolean sourceTranslationFuzzy) {
        this.sourceTranslationFuzzy = sourceTranslationFuzzy;
    }

    public ProtectedPart[] getProtectedParts() {
        return this.protectedParts;
    }

    public boolean isParagraphStart() {
        return this.paragraphStart;
    }

    public static enum DUPLICATE {
        NONE,
        FIRST,
        NEXT;

    }
}

