/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.scripting;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Scanner;
import java.util.regex.MatchResult;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.omegat.util.LinebreakPreservingReader;

public class ScriptItem
implements Comparable<ScriptItem> {
    protected static final String EDITOR_SCRIPT = "<editor script>";
    private static final String PROPERTIES = "properties/";
    private static final String BOM = "\ufeff";
    private boolean startsWithBOM = false;
    private String lineBreak = System.lineSeparator();
    private final Optional<File> mFile;
    private final Optional<String> mSource;
    private String mScriptName = null;
    private String mDescription = null;
    private ResourceBundle mRes = null;

    public ScriptItem(String scriptSource) {
        this.mSource = Optional.of(scriptSource);
        this.mFile = Optional.empty();
    }

    public ScriptItem(File scriptFile) {
        this.mFile = Optional.of(scriptFile);
        this.mSource = Optional.empty();
        if (this.mFile == null) {
            return;
        }
        try {
            URLClassLoader loader = new URLClassLoader(new URL[]{scriptFile.getParentFile().toURI().toURL()});
            String shortName = FilenameUtils.removeExtension((String)scriptFile.getName());
            try {
                this.mRes = ResourceBundle.getBundle(shortName, Locale.getDefault(), loader);
            }
            catch (MissingResourceException e) {
                try {
                    this.mRes = ResourceBundle.getBundle(PROPERTIES + shortName, Locale.getDefault(), loader);
                }
                catch (MissingResourceException ex) {
                    this.scanFileForDescription(scriptFile);
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    private void scanFileForDescription(File file) {
        try (Scanner scan = new Scanner(file, StandardCharsets.UTF_8.name());){
            scan.findInLine(":name\\s*=\\s*(.*)\\s+:description\\s*=\\s*(.*)");
            MatchResult results = scan.match();
            this.mScriptName = results.group(1).trim();
            this.mDescription = results.group(2).trim();
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public ResourceBundle getResourceBundle() {
        if (this.mRes != null) {
            return this.mRes;
        }
        return new ResourceBundle(){
            static final String MISSING_BUNDLE_MESSAGE = "ResourceBundle (.properties file for localization) is missing.";

            @Override
            protected Object handleGetObject(String key) {
                throw new MissingResourceException(MISSING_BUNDLE_MESSAGE, null, key);
            }

            @Override
            public Enumeration<String> getKeys() {
                throw new MissingResourceException(MISSING_BUNDLE_MESSAGE, null, null);
            }
        };
    }

    public String getScriptName() {
        if (this.mScriptName == null && this.mFile.isPresent()) {
            String name = this.mFile.get().getName();
            if (this.mRes != null) {
                try {
                    name = this.mRes.getString("name");
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            this.mScriptName = name;
        }
        return this.mScriptName;
    }

    public String getFileName() {
        if (this.mFile.isPresent()) {
            return this.mFile.get().getName();
        }
        return EDITOR_SCRIPT;
    }

    public File getFile() {
        return this.mFile.orElse(null);
    }

    public String getDescription() {
        if (this.mDescription != null) {
            return this.mDescription;
        }
        try {
            this.mDescription = this.mRes == null ? "" : this.mRes.getString("description");
        }
        catch (MissingResourceException e) {
            this.mDescription = "";
        }
        return this.mDescription;
    }

    public String getToolTip() {
        String name = this.getScriptName();
        String description = this.getDescription();
        return "".equals(description) ? name : name + " - " + description;
    }

    public String getText() throws FileNotFoundException, IOException {
        if (!this.mFile.isPresent() && !this.mSource.isPresent()) {
            throw new IOException("Cannot run a script item without source.");
        }
        if (this.mSource.isPresent()) {
            return this.mSource.get();
        }
        StringBuilder sb = new StringBuilder();
        try (LinebreakPreservingReader lpin = this.getUTF8LinebreakPreservingReader(this.mFile.get());){
            String s = lpin.readLine();
            if (s != null) {
                this.startsWithBOM = s.startsWith(BOM);
                if (this.startsWithBOM) {
                    s = s.substring(1);
                }
            }
            while (s != null) {
                sb.append(s);
                String br = lpin.getLinebreak();
                if (!br.isEmpty()) {
                    this.lineBreak = br;
                    sb.append('\n');
                }
                s = lpin.readLine();
            }
        }
        return sb.toString();
    }

    private LinebreakPreservingReader getUTF8LinebreakPreservingReader(File file) throws FileNotFoundException, UnsupportedEncodingException {
        FileInputStream is = new FileInputStream(file);
        InputStreamReader isr = new InputStreamReader((InputStream)is, StandardCharsets.UTF_8);
        BufferedReader in = new BufferedReader(isr);
        return new LinebreakPreservingReader(in);
    }

    public void setText(String text) throws UnsupportedEncodingException, IOException {
        if (!this.mSource.isPresent() && !this.mFile.isPresent()) {
            throw new IOException("Cannot save inline script source.");
        }
        text = text.replaceAll("\n", this.lineBreak);
        if (this.startsWithBOM) {
            text = BOM + text;
        }
        FileUtils.writeStringToFile((File)this.mFile.get(), (String)text, (Charset)StandardCharsets.UTF_8);
    }

    public String toString() {
        return this.getScriptName();
    }

    @Override
    public int compareTo(ScriptItem o) {
        return this.getScriptName().compareTo(o.getScriptName());
    }
}

