/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.machinetranslators;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import org.omegat.core.Core;
import org.omegat.gui.exttrans.IMTGlossarySupplier;
import org.omegat.gui.exttrans.IMachineTranslation;
import org.omegat.util.CredentialsManager;
import org.omegat.util.Language;
import org.omegat.util.PatternConsts;
import org.omegat.util.Preferences;
import org.openide.awt.Mnemonics;

public abstract class BaseTranslate
implements IMachineTranslation {
    protected boolean enabled;
    protected IMTGlossarySupplier glossarySupplier;
    private final Map<String, String> cache = Collections.synchronizedMap(new HashMap());

    public BaseTranslate() {
        JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem();
        Mnemonics.setLocalizedText((AbstractButton)menuItem, (String)this.getName());
        menuItem.addActionListener(e -> this.setEnabled(menuItem.isSelected()));
        this.enabled = Preferences.isPreference(this.getPreferenceName());
        menuItem.setState(this.enabled);
        Core.getMainWindow().getMainMenu().getMachineTranslationMenu().add(menuItem);
        Preferences.addPropertyChangeListener(this.getPreferenceName(), e -> {
            boolean newValue = (Boolean)e.getNewValue();
            menuItem.setSelected(newValue);
            this.enabled = newValue;
        });
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        Preferences.setPreference(this.getPreferenceName(), enabled);
    }

    @Override
    public void setGlossarySupplier(IMTGlossarySupplier glossarySupplier) {
        this.glossarySupplier = glossarySupplier;
    }

    @Override
    public String getTranslation(Language sLang, Language tLang, String text) throws Exception {
        if (this.enabled) {
            return this.translate(sLang, tLang, text);
        }
        return null;
    }

    @Override
    public String getCachedTranslation(Language sLang, Language tLang, String text) {
        if (this.enabled) {
            return this.getFromCache(sLang, tLang, text);
        }
        return null;
    }

    protected abstract String getPreferenceName();

    protected abstract String translate(Language var1, Language var2, String var3) throws Exception;

    protected String cleanSpacesAroundTags(String machineText, String sourceText) {
        String replacement;
        String searchTag;
        Matcher tag = PatternConsts.OMEGAT_TAG_SPACE.matcher(machineText);
        while (tag.find()) {
            searchTag = tag.group();
            if (sourceText.indexOf(searchTag) != -1) continue;
            replacement = searchTag.substring(0, searchTag.length() - 1);
            machineText = machineText.replace(searchTag, replacement);
        }
        tag = PatternConsts.SPACE_OMEGAT_TAG.matcher(machineText);
        while (tag.find()) {
            searchTag = tag.group();
            if (sourceText.indexOf(searchTag) != -1) continue;
            replacement = searchTag.substring(1, searchTag.length());
            machineText = machineText.replace(searchTag, replacement);
        }
        return machineText;
    }

    protected String getFromCache(Language sLang, Language tLang, String text) {
        return this.cache.get(sLang + "/" + tLang + "/" + text);
    }

    protected String putToCache(Language sLang, Language tLang, String text, String result) {
        return this.cache.put(sLang + "/" + tLang + "/" + text, result);
    }

    protected void clearCache() {
        this.cache.clear();
    }

    protected String getCredential(String id) {
        String property = System.getProperty(id);
        if (property != null) {
            return property;
        }
        return CredentialsManager.getInstance().retrieve(id).orElse("");
    }

    protected void setCredential(String id, String value, boolean temporary) {
        System.setProperty(id, value);
        CredentialsManager.getInstance().store(id, temporary ? "" : value);
    }

    protected boolean isCredentialStoredTemporarily(String id) {
        return !CredentialsManager.getInstance().isStored(id) && !System.getProperty(id, "").isEmpty();
    }
}

