/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.de.GermanHelper;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tools.StringTools;

class AgreementSuggestor {
    private final Synthesizer synthesizer;
    private final AnalyzedTokenReadings determinerToken;
    private final AnalyzedTokenReadings nounToken;

    AgreementSuggestor(Synthesizer synthesizer, AnalyzedTokenReadings determinerToken, AnalyzedTokenReadings nounToken) {
        this.synthesizer = synthesizer;
        this.determinerToken = determinerToken;
        this.nounToken = nounToken;
    }

    List<String> getSuggestions() {
        HashSet<String> suggestionSet = new HashSet<String>();
        try {
            for (AnalyzedToken token2Reading : this.nounToken.getReadings()) {
                String nounCase = GermanHelper.getNounCase(token2Reading.getPOSTag());
                String nounNumber = GermanHelper.getNounNumber(token2Reading.getPOSTag());
                String nounGender = GermanHelper.getNounGender(token2Reading.getPOSTag());
                for (AnalyzedToken token1Reading : this.determinerToken.getReadings()) {
                    List<String> articleSuggestions = this.getArticleSuggestions(nounCase, nounNumber, nounGender, token1Reading);
                    suggestionSet.addAll(articleSuggestions);
                    List<String> pronounSuggestions = this.getPronounSuggestions(nounCase, nounNumber, nounGender, token1Reading);
                    suggestionSet.addAll(pronounSuggestions);
                    List<String> nounSuggestions = this.getNounSuggestions(token2Reading, token1Reading);
                    suggestionSet.addAll(nounSuggestions);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ArrayList<String> suggestions = new ArrayList<String>(suggestionSet);
        Collections.sort(suggestions);
        return suggestions;
    }

    private List<String> getArticleSuggestions(String nounCase, String nounNumber, String nounGender, AnalyzedToken article) throws IOException {
        String determinerDefiniteness = GermanHelper.getDeterminerDefiniteness(article.getPOSTag());
        if (StringTools.isEmpty((String)determinerDefiniteness)) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        String correctPosTag1 = "ART:" + determinerDefiniteness + ":" + nounCase + ":" + nounNumber + ":" + nounGender;
        result.addAll(this.getDeterminerSuggestionsForPosTag(article, correctPosTag1, null));
        String correctPosTag2 = "PRO:DEM:" + nounCase + ":" + nounNumber + ":" + nounGender + ":B/S";
        result.addAll(this.getDeterminerSuggestionsForPosTag(article, correctPosTag2, null));
        return result;
    }

    private List<String> getPronounSuggestions(String nounCase, String nounNumber, String nounGender, AnalyzedToken pronoun) throws IOException {
        String correctPosTag = "PRO:POS:" + nounCase + ":" + nounNumber + ":" + nounGender + ":BEG";
        return this.getDeterminerSuggestionsForPosTag(pronoun, correctPosTag, this.determinerToken.getToken().substring(0, 1));
    }

    private List<String> getNounSuggestions(AnalyzedToken token2Reading, AnalyzedToken determiner) throws IOException {
        if (determiner.getPOSTag() != null && determiner.getPOSTag().endsWith(":STV")) {
            return Collections.emptyList();
        }
        String determinerCase = GermanHelper.getDeterminerCase(determiner.getPOSTag());
        String determinerNumber = GermanHelper.getDeterminerNumber(determiner.getPOSTag());
        String determinerGender = GermanHelper.getDeterminerGender(determiner.getPOSTag());
        String correctPosTag = "SUB:" + determinerCase + ":" + determinerNumber + ":" + determinerGender;
        return this.getNounSuggestionsForPosTag(this.determinerToken, token2Reading, correctPosTag);
    }

    private List<String> getDeterminerSuggestionsForPosTag(AnalyzedToken token1Reading, String correctPosTag, String startsWith) throws IOException {
        String[] correctedDeterminer;
        ArrayList<String> suggestions = new ArrayList<String>();
        for (String determiner : correctedDeterminer = this.synthesizer.synthesize(token1Reading, correctPosTag)) {
            if (startsWith != null && !determiner.startsWith(startsWith)) continue;
            String correctDeterminer = StringTools.isCapitalizedWord((String)this.determinerToken.getToken()) ? StringTools.uppercaseFirstChar((String)determiner) : determiner;
            suggestions.add(correctDeterminer + " " + this.nounToken.getToken());
        }
        return suggestions;
    }

    private List<String> getNounSuggestionsForPosTag(AnalyzedTokenReadings token1, AnalyzedToken token2Reading, String correctPosTag) throws IOException {
        String[] correctedNouns;
        ArrayList<String> suggestions = new ArrayList<String>();
        for (String correctedNoun : correctedNouns = this.synthesizer.synthesize(token2Reading, correctPosTag)) {
            suggestions.add(token1.getToken() + " " + correctedNoun);
        }
        return suggestions;
    }
}

