/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.io.IOException;
import java.util.ResourceBundle;
import org.languagetool.rules.AbstractCompoundRule;
import org.languagetool.rules.CompoundRuleData;
import org.languagetool.rules.Example;

public class CompoundRule
extends AbstractCompoundRule {
    private static final CompoundRuleData compoundData = new CompoundRuleData("/en/compounds.txt");

    public CompoundRule(ResourceBundle messages) throws IOException {
        super(messages, "This word is normally spelled with hyphen.", "This word is normally spelled as one.", "This expression is normally spelled as one or with hyphen.", "Hyphenation problem");
        this.addExamplePair(Example.wrong((String)"I now have a <marker>part time</marker> job."), Example.fixed((String)"I now have a <marker>part-time</marker> job."));
    }

    public String getId() {
        return "EN_COMPOUNDS";
    }

    public String getDescription() {
        return "Hyphenated words, e.g., 'case-sensitive' instead of 'case sensitive'";
    }

    protected CompoundRuleData getCompoundRuleData() {
        return compoundData;
    }
}

