/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.main;

import com.vlsolutions.swing.docking.DockKey;
import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockableState;
import com.vlsolutions.swing.docking.DockingConstants;
import java.awt.Component;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;
import org.omegat.util.gui.IPaneMenu;

public class DockableScrollPane
extends JScrollPane
implements Dockable {
    DockKey dockKey;

    @Override
    public void setToolTipText(String text) {
        this.dockKey.setTooltip(text);
    }

    @Override
    public void setName(String name) {
        this.dockKey.setName(name);
    }

    public DockableScrollPane(String key, String name, Component view, boolean detouchable) {
        super(view);
        Border viewportBorder;
        Border panelBorder;
        if (view instanceof JTextComponent && UIManager.getBoolean("OmegaTDockablePanel.isProportionalMargins")) {
            JTextComponent c = (JTextComponent)view;
            int size = c.getFont().getSize() / 2;
            c.setBorder(new EmptyBorder(size, size, size, size));
        }
        if ((panelBorder = UIManager.getBorder("OmegaTDockablePanel.border")) != null) {
            this.setBorder(panelBorder);
        }
        if ((viewportBorder = UIManager.getBorder("OmegaTDockablePanelViewport.border")) != null) {
            this.setViewportBorder(viewportBorder);
        }
        this.dockKey = new DockKey(key, name, null, null, DockingConstants.HIDE_BOTTOM);
        this.dockKey.setFloatEnabled(detouchable);
        this.dockKey.setCloseEnabled(false);
        if (view instanceof IPaneMenu) {
            this.setMenuProvider((IPaneMenu)((Object)view));
        }
    }

    public void setMenuProvider(IPaneMenu provider) {
        this.dockKey.putProperty("pane_menu_action_listener", provider);
    }

    @Override
    public DockKey getDockKey() {
        return this.dockKey;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    public void notify(boolean onlyIfMinimized) {
        if (onlyIfMinimized && this.dockKey.getLocation() != DockableState.Location.HIDDEN) {
            return;
        }
        this.dockKey.setNotification(true);
    }

    public void stopNotifying() {
        this.dockKey.setNotification(false);
    }
}

