/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.externalfinder.item;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.omegat.externalfinder.item.ExternalFinderItem;
import org.omegat.externalfinder.item.ExternalFinderValidationException;
import org.omegat.util.OStrings;

public class ExternalFinderItemURL {
    private final String url;
    private final ExternalFinderItem.TARGET target;
    private final ExternalFinderItem.ENCODING encoding;

    public ExternalFinderItemURL(String url, ExternalFinderItem.TARGET target, ExternalFinderItem.ENCODING encoding) {
        this.url = url;
        this.target = target;
        this.encoding = encoding;
    }

    public String getURL() {
        return this.url;
    }

    public ExternalFinderItem.TARGET getTarget() {
        return this.target;
    }

    public ExternalFinderItem.ENCODING getEncoding() {
        return this.encoding;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.encoding == null ? 0 : this.encoding.hashCode());
        result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExternalFinderItemURL other = (ExternalFinderItemURL)obj;
        if (this.encoding != other.encoding) {
            return false;
        }
        if (this.target != other.target) {
            return false;
        }
        return !(this.url == null ? other.url != null : !this.url.equals(other.url));
    }

    public URI generateURL(String findingWords) throws UnsupportedEncodingException, URISyntaxException {
        return ExternalFinderItemURL.generateURL(this.url, this.encoding, findingWords);
    }

    private static URI generateURL(String url, ExternalFinderItem.ENCODING encoding, String findingWords) throws UnsupportedEncodingException, URISyntaxException {
        String encodedWords;
        if (encoding == ExternalFinderItem.ENCODING.NONE) {
            encodedWords = findingWords;
        } else {
            encodedWords = URLEncoder.encode(findingWords, StandardCharsets.UTF_8.name());
            if (encoding == ExternalFinderItem.ENCODING.ESCAPE) {
                encodedWords = encodedWords.replace("+", "%20");
            }
        }
        String replaced = url.replace("{target}", encodedWords);
        return new URI(replaced);
    }

    public static final class Builder {
        private String url;
        private ExternalFinderItem.TARGET target = ExternalFinderItem.TARGET.BOTH;
        private ExternalFinderItem.ENCODING encoding = ExternalFinderItem.ENCODING.DEFAULT;

        public static Builder from(ExternalFinderItemURL item) {
            return new Builder().setURL(item.getURL()).setTarget(item.getTarget()).setEncoding(item.getEncoding());
        }

        public Builder setURL(String url) {
            this.url = url;
            return this;
        }

        public String getURL() {
            return this.url;
        }

        public Builder setTarget(ExternalFinderItem.TARGET target) {
            this.target = target;
            return this;
        }

        public ExternalFinderItem.TARGET getTarget() {
            return this.target;
        }

        public Builder setEncoding(ExternalFinderItem.ENCODING encoding) {
            this.encoding = encoding;
            return this;
        }

        public ExternalFinderItem.ENCODING getEncoding() {
            return this.encoding;
        }

        public ExternalFinderItemURL build() throws ExternalFinderValidationException {
            this.validate();
            return new ExternalFinderItemURL(this.url, this.target, this.encoding);
        }

        public URI validate() throws ExternalFinderValidationException {
            if (this.url == null) {
                throw new ExternalFinderValidationException(OStrings.getString("EXTERNALFINDER_URL_ERROR_NOURL"));
            }
            if (!this.url.contains("{target}")) {
                throw new ExternalFinderValidationException(OStrings.getString("EXTERNALFINDER_URL_ERROR_NOTOKEN", "{target}"));
            }
            if (this.target == null) {
                throw new ExternalFinderValidationException("EXTERNALFINDER_URL_ERROR_NOTARGET");
            }
            if (this.encoding == null) {
                throw new ExternalFinderValidationException("EXTERNALFINDER_URL_ERROR_NOENCODING");
            }
            try {
                return this.generateSampleURL();
            }
            catch (Throwable e) {
                throw new ExternalFinderValidationException(e);
            }
        }

        public URI generateSampleURL() throws UnsupportedEncodingException, URISyntaxException {
            String findingWords = this.target == ExternalFinderItem.TARGET.NON_ASCII_ONLY ? "f\u00f8\u00f8 b\u00e5r" : "foo bar";
            return ExternalFinderItemURL.generateURL(this.url, this.encoding, findingWords);
        }
    }
}

