/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.fa;

import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.Example;
import org.languagetool.rules.WordRepeatBeginningRule;

public class PersianWordRepeatBeginningRule
extends WordRepeatBeginningRule {
    private static final Set<String> ADVERBS = new HashSet<String>();

    public PersianWordRepeatBeginningRule(ResourceBundle messages, Language language) {
        super(messages, language);
        this.addExamplePair(Example.wrong((String)"\u0647\u0645\u0686\u0646\u06cc\u0646\u060c \u062e\u06cc\u0627\u0628\u0627\u0646 \u062a\u0642\u0631\u06cc\u0628\u0627\u064b \u06a9\u0627\u0645\u0644\u0627\u064b \u0645\u0633\u06a9\u0648\u0646\u06cc \u0627\u0633\u062a. <marker>\u0647\u0645\u0686\u0646\u06cc\u0646</marker>\u060c \u0628\u0647 \u0627\u0641\u062a\u062e\u0627\u0631 \u06cc\u06a9 \u0634\u0627\u0639\u0631 \u0646\u0627\u0645\u06af\u0630\u0627\u0631\u06cc \u0634\u062f\u0647\u200c\u0627\u0633\u062a."), Example.fixed((String)"\u0647\u0645\u0686\u0646\u06cc\u0646\u060c \u062e\u06cc\u0627\u0628\u0627\u0646 \u062a\u0642\u0631\u06cc\u0628\u0627\u064b \u0645\u0633\u06a9\u0648\u0646\u06cc \u0627\u0633\u062a. <marker>\u0627\u06cc\u0646 \u062e\u06cc\u0627\u0628\u0627\u0646</marker> \u0628\u0647 \u0627\u0641\u062a\u062e\u0627\u0631 \u06cc\u06a9 \u0634\u0627\u0639\u0631 \u0646\u0627\u0645\u06af\u0630\u0627\u0631\u06cc \u0634\u062f\u0647\u200c\u0627\u0633\u062a."));
    }

    public String getId() {
        return "PERSIAN_WORD_REPEAT_BEGINNING_RULE";
    }

    protected boolean isAdverb(AnalyzedTokenReadings token) {
        return ADVERBS.contains(token.getToken());
    }

    static {
        ADVERBS.add("\u0647\u0645");
        ADVERBS.add("\u0647\u0645\u0686\u0646\u06cc\u0646");
        ADVERBS.add("\u0646\u06cc\u0632");
        ADVERBS.add("\u0627\u0632 \u06cc\u06a9 \u0633\u0648");
        ADVERBS.add("\u0627\u0632 \u06cc\u06a9 \u0637\u0631\u0641");
        ADVERBS.add("\u0627\u0632 \u0637\u0631\u0641 \u062f\u064a\u06af\u0631");
        ADVERBS.add("\u0628\u0646\u0627\u0628\u0631\u0627\u06cc\u0646");
        ADVERBS.add("\u062d\u062a\u06cc");
        ADVERBS.add("\u0686\u0646\u0627\u0646\u0686\u0647");
    }
}

