/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.docking.ws;

import com.vlsolutions.swing.docking.DockingContext;
import com.vlsolutions.swing.docking.ws.WSDesktop;
import com.vlsolutions.swing.docking.ws.WorkspaceException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Workspace {
    private ArrayList<WSDesktop> desktops = new ArrayList();

    public Workspace() {
        this.desktops.add(new WSDesktop());
    }

    public void clear() {
        this.desktops.clear();
    }

    public void addDesktop(WSDesktop desktop) {
        this.desktops.add(desktop);
    }

    public int getDesktopCount() {
        return this.desktops.size();
    }

    public WSDesktop getDesktop(int index) {
        return this.desktops.get(index);
    }

    public WSDesktop getDesktop(String desktopName) {
        if (this.desktops.size() == 1) {
            return this.desktops.get(0);
        }
        for (int i = 0; i < this.desktops.size(); ++i) {
            WSDesktop d = this.desktops.get(i);
            if (!d.getDesktopName().equals(desktopName)) continue;
            return d;
        }
        return null;
    }

    public void apply(DockingContext dockingContext) throws WorkspaceException {
        ByteArrayOutputStream outb = new ByteArrayOutputStream();
        PrintWriter out = new PrintWriter(outb);
        out.println("<?xml version=\"1.0\"?>");
        out.println("<VLDocking version=\"2.1\">");
        for (int i = 0; i < this.desktops.size(); ++i) {
            WSDesktop desktop = this.desktops.get(i);
            desktop.writeDesktopNode(out);
        }
        out.println("</VLDocking>");
        out.close();
        byte[] bytes = outb.toByteArray();
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        try {
            dockingContext.readXML(is);
        }
        catch (Exception ex) {
            throw new WorkspaceException(ex);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
    }

    public void loadFrom(DockingContext context) throws WorkspaceException {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            context.writeXML(out);
            out.close();
            byte[] bytes = out.toByteArray();
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            this.readXML(is);
            is.close();
        }
        catch (Exception e) {
            throw new WorkspaceException(e);
        }
    }

    public void writeXML(OutputStream stream) throws IOException {
        PrintWriter out = new PrintWriter(stream);
        out.println("<?xml version=\"1.0\"?>");
        out.println("<VLDocking version=\"2.1\">");
        for (int i = 0; i < this.desktops.size(); ++i) {
            WSDesktop desktop = this.desktops.get(i);
            desktop.writeDesktopNode(out);
        }
        out.println("</VLDocking>");
        out.flush();
    }

    public void readXML(InputStream in) throws ParserConfigurationException, IOException, SAXException {
        for (int i = 0; i < this.desktops.size(); ++i) {
            WSDesktop desk = this.desktops.get(i);
            desk.clear();
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(in);
        Element root = doc.getDocumentElement();
        if (root.getNodeName().equals("DockingDesktop")) {
            WSDesktop desk = this.getDesktop(0);
            desk.readDesktopNode(root);
        } else {
            NodeList desktopChildren = root.getChildNodes();
            int len = desktopChildren.getLength();
            for (int i = 0; i < len; ++i) {
                Node node = desktopChildren.item(i);
                if (!(node instanceof Element)) continue;
                Element deskChild = (Element)node;
                WSDesktop desk = this.getDesktop(deskChild.getAttribute("name"));
                desk.readDesktopNode(deskChild);
            }
        }
    }
}

