/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.spellchecker;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import org.apache.commons.io.FilenameUtils;
import org.omegat.util.PatternConsts;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;

public class DictionaryManager {
    private static final int TIMEOUT_MS = 10000;
    private final File dir;

    public DictionaryManager(File dir) {
        this.dir = dir;
    }

    public String getDirectory() {
        return this.dir.getAbsolutePath();
    }

    public List<String> getDictionaryNameList(List<String> aList) {
        ArrayList<String> result = new ArrayList<String>();
        for (String dic : aList) {
            String[] parts = dic.split("_");
            Locale locale = parts.length == 1 ? new Locale(parts[0]) : new Locale(parts[0], parts[1]);
            result.add(dic + " - " + locale.getDisplayName());
        }
        return result;
    }

    public List<String> getLocalDictionaryNameList() {
        return this.getDictionaryNameList(this.getLocalDictionaryCodeList());
    }

    public List<String> getLocalDictionaryCodeList() {
        ArrayList<String> result = new ArrayList<String>();
        String[] affixFiles = this.dir.list((d, name) -> name.endsWith(".aff"));
        String[] dictionaryFiles = this.dir.list((d, name) -> name.endsWith(".dic"));
        if (affixFiles != null && dictionaryFiles != null) {
            for (String affixFile : affixFiles) {
                boolean match = false;
                String affixName = FilenameUtils.getBaseName((String)affixFile);
                if (affixName == null || affixName.isEmpty()) continue;
                for (String dictionaryFile : dictionaryFiles) {
                    String dicName = FilenameUtils.getBaseName((String)dictionaryFile);
                    if (dicName == null || dicName.isEmpty() || !affixName.equals(dicName)) continue;
                    match = true;
                    break;
                }
                if (!match) continue;
                result.add(affixName);
            }
        }
        return result;
    }

    public boolean uninstallDictionary(String lang) {
        if (lang == null || lang.isEmpty()) {
            return false;
        }
        String base = this.getDirectory() + File.separator + lang;
        File affFile = new File(base + ".aff");
        if (!affFile.delete()) {
            return false;
        }
        File dicFile = new File(base + ".dic");
        return dicFile.delete();
    }

    public List<String> getInstallableDictionaryNameList() throws IOException {
        return this.getDictionaryNameList(this.getInstallableDictionaryCodeList());
    }

    public List<String> getInstallableDictionaryCodeList() throws IOException {
        List<String> localDicList = this.getLocalDictionaryCodeList();
        List<String> remoteDicList = this.getRemoteDictionaryCodeList();
        ArrayList<String> result = new ArrayList<String>();
        for (String dicCode : remoteDicList) {
            if (localDicList.contains(dicCode)) continue;
            result.add(dicCode);
        }
        return result;
    }

    private List<String> getRemoteDictionaryCodeList() throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        URL url = new URL(Preferences.getPreference("dictionary_url"));
        String htmlfile = StaticUtils.downloadFileToString(url, 10000);
        Matcher matcher = PatternConsts.DICTIONARY_ZIP.matcher(htmlfile);
        while (matcher.find()) {
            String match = matcher.group();
            int dotPosition = match.indexOf(".");
            result.add(match.substring(1, dotPosition));
        }
        return result;
    }

    public void installRemoteDictionary(String langCode) throws MalformedURLException, IOException {
        String from = Preferences.getPreference("dictionary_url") + "/" + langCode + ".zip";
        int pos = langCode.indexOf("_1-3-2", 0);
        if (pos != -1) {
            langCode = langCode.substring(0, pos);
        }
        List<String> expectedFiles = Arrays.asList(langCode + ".aff", langCode + ".dic");
        URL url = new URL(from);
        URLConnection conn = url.openConnection();
        conn.setConnectTimeout(10000);
        conn.setReadTimeout(10000);
        try (InputStream in = conn.getInputStream();){
            List<String> extracted = StaticUtils.extractFromZip(in, this.dir, expectedFiles::contains);
            if (!expectedFiles.containsAll(extracted)) {
                throw new FileNotFoundException("Could not extract expected files from zip; expected: " + expectedFiles + ", extracted: " + extracted);
            }
        }
        catch (IllegalArgumentException ex) {
            throw new FlakyDownloadException(ex);
        }
    }

    public static class FlakyDownloadException
    extends RuntimeException {
        public FlakyDownloadException(Exception cause) {
            super(cause);
        }
    }
}

