/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.docking;

import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.docking.DockingPreferences;
import com.vlsolutions.swing.docking.DragControler;
import com.vlsolutions.swing.docking.HeavyWeightDragControler;
import com.vlsolutions.swing.docking.LightWeightDragControler;

public class DragControlerFactory {
    private static DragControlerFactory instance;

    public DragControler createDragControler(DockingDesktop desktop) {
        if (DockingPreferences.isLightWeightUsageEnabled()) {
            return new LightWeightDragControler(desktop);
        }
        return new HeavyWeightDragControler(desktop);
    }

    public static DragControlerFactory getInstance() {
        if (instance == null) {
            instance = new DragControlerFactory();
        }
        return instance;
    }

    public static void setInstance(DragControlerFactory instance) {
        DragControlerFactory.instance = instance;
    }
}

