/*
 * Decompiled with CFR 0.152.
 */
package net.java.sen;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import net.java.sen.StringTagger;
import net.java.sen.dictionary.Token;
import net.java.sen.filter.StreamFilter;

public class StreamTagger {
    private StringTagger stringTagger = null;
    private static final int BUFFER_SIZE = 256;
    private final char[] buffer = new char[256];
    private int currentTokenIndex = 0;
    private List<Token> tokens;
    private boolean complete = false;
    private Reader reader;
    private int lastReadOffset;

    private int readToBuffer() throws IOException {
        int position;
        int charactersRead = 0;
        for (position = 0; position < 256 && !this.complete && (charactersRead = this.reader.read(this.buffer, position, 1)) != -1; ++position) {
            if (Character.getType(this.buffer[position]) != 24 || position <= 0) continue;
            return position + 1;
        }
        if (charactersRead == -1) {
            this.complete = true;
        }
        if (this.complete && position == 0) {
            return -1;
        }
        return position;
    }

    public boolean hasNext() throws IOException {
        if (this.tokens == null || this.currentTokenIndex == this.tokens.size()) {
            int i;
            do {
                if ((i = this.readToBuffer()) == -1) {
                    return false;
                }
                this.tokens = this.stringTagger.analyze(new String(this.buffer, 0, i));
            } while (this.tokens == null);
            this.currentTokenIndex = 0;
            if (this.tokens != null) {
                for (int n = 0; n < this.tokens.size(); ++n) {
                    Token token = this.tokens.get(n);
                    token.setSentenceStart(n == 0);
                    token.setStart(token.getStart() + this.lastReadOffset);
                }
            }
            this.lastReadOffset += i;
        }
        return this.tokens.size() != 0;
    }

    public Token next() throws IOException {
        if (this.tokens == null || this.tokens.size() == this.currentTokenIndex) {
            int i;
            do {
                if ((i = this.readToBuffer()) == -1) {
                    return null;
                }
                this.tokens = this.stringTagger.analyze(new String(this.buffer, 0, i));
            } while (this.tokens == null || this.tokens.isEmpty());
            this.currentTokenIndex = 0;
            if (this.tokens != null) {
                for (int n = 0; n < this.tokens.size(); ++n) {
                    Token token = this.tokens.get(n);
                    token.setSentenceStart(n == 0);
                    token.setStart(token.getStart() + this.lastReadOffset);
                }
            }
            this.lastReadOffset += i;
        }
        return this.tokens.get(this.currentTokenIndex++);
    }

    public void addFilter(StreamFilter filter) {
        this.stringTagger.addFilter(filter);
    }

    public StreamTagger(StringTagger stringTagger, Reader reader) {
        this.stringTagger = stringTagger;
        this.reader = reader;
        this.lastReadOffset = 0;
    }
}

