/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanScorer;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.Bits;

public class SpanWeight
extends Weight {
    protected final Similarity similarity;
    protected final Map<Term, TermContext> termContexts;
    protected final SpanQuery query;
    protected Similarity.SimWeight stats;

    public SpanWeight(SpanQuery query, IndexSearcher searcher, boolean needsScores) throws IOException {
        super(query);
        this.similarity = searcher.getSimilarity(needsScores);
        this.query = query;
        this.termContexts = new HashMap<Term, TermContext>();
        TreeSet<Term> terms = new TreeSet<Term>();
        query.extractTerms(terms);
        IndexReaderContext context = searcher.getTopReaderContext();
        TermStatistics[] termStats = new TermStatistics[terms.size()];
        int i = 0;
        for (Term term : terms) {
            TermContext state = TermContext.build(context, term);
            termStats[i] = searcher.termStatistics(term, state);
            this.termContexts.put(term, state);
            ++i;
        }
        String field = query.getField();
        if (field != null) {
            this.stats = this.similarity.computeWeight(query.getBoost(), searcher.collectionStatistics(query.getField()), termStats);
        }
    }

    @Override
    public void extractTerms(Set<Term> terms) {
        this.query.extractTerms(terms);
    }

    @Override
    public float getValueForNormalization() throws IOException {
        return this.stats == null ? 1.0f : this.stats.getValueForNormalization();
    }

    @Override
    public void normalize(float queryNorm, float topLevelBoost) {
        if (this.stats != null) {
            this.stats.normalize(queryNorm, topLevelBoost);
        }
    }

    @Override
    public Scorer scorer(LeafReaderContext context, Bits acceptDocs) throws IOException {
        if (this.stats == null) {
            return null;
        }
        Terms terms = context.reader().terms(this.query.getField());
        if (terms != null && !terms.hasPositions()) {
            throw new IllegalStateException("field \"" + this.query.getField() + "\" was indexed without position data; cannot run SpanQuery (query=" + this.query + ")");
        }
        Spans spans = this.query.getSpans(context, acceptDocs, this.termContexts);
        return spans == null ? null : new SpanScorer(spans, this, this.similarity.simScorer(this.stats, context));
    }

    @Override
    public Explanation explain(LeafReaderContext context, int doc) throws IOException {
        int newDoc;
        SpanScorer scorer = (SpanScorer)this.scorer(context, context.reader().getLiveDocs());
        if (scorer != null && (newDoc = scorer.advance(doc)) == doc) {
            float freq = scorer.sloppyFreq();
            Similarity.SimScorer docScorer = this.similarity.simScorer(this.stats, context);
            Explanation freqExplanation = Explanation.match(freq, "phraseFreq=" + freq, new Explanation[0]);
            Explanation scoreExplanation = docScorer.explain(doc, freqExplanation);
            return Explanation.match(scoreExplanation.getValue(), "weight(" + this.getQuery() + " in " + doc + ") [" + this.similarity.getClass().getSimpleName() + "], result of:", scoreExplanation);
        }
        return Explanation.noMatch("no matching term", new Explanation[0]);
    }
}

