/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters3.xml.xhtml;

import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.omegat.filters3.Attribute;
import org.omegat.filters3.Attributes;
import org.omegat.filters3.xml.DefaultXMLDialect;
import org.omegat.filters3.xml.xhtml.XHTMLOptions;
import org.omegat.util.Log;
import org.omegat.util.StringUtil;
import org.xml.sax.InputSource;

public class XHTMLDialect
extends DefaultXMLDialect {
    private static final Pattern XHTML_PUBLIC_DTD = Pattern.compile("-//W3C//DTD XHTML.*");
    private static final Pattern PUBLIC_XHTML = Pattern.compile("-//W3C//DTD\\s+XHTML.+");
    private static final String DTD = "/org/omegat/filters3/xml/xhtml/res/xhtml2-flat.dtd";
    private Boolean translateValue = false;
    private Boolean translateButtonValue = false;
    private Pattern skipRegExpPattern;
    private HashMap<String, String> skipMetaAttributes;
    private HashMap<String, String> ignoreTagsAttributes;

    public XHTMLDialect() {
        this.defineConstraint(2, XHTML_PUBLIC_DTD);
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        if (publicId != null && PUBLIC_XHTML.matcher(publicId).matches() && systemId.endsWith(".dtd")) {
            URL dtdresource = XHTMLDialect.class.getResource(DTD);
            return new InputSource(dtdresource.toExternalForm());
        }
        return null;
    }

    public void defineDialect(XHTMLOptions options) {
        String skipRegExp;
        this.defineParagraphTags(new String[]{"html", "head", "title", "body", "address", "blockquote", "center", "div", "h1", "h2", "h3", "h4", "h5", "table", "th", "tr", "td", "p", "ol", "ul", "li", "dl", "dt", "dd", "form", "textarea", "fieldset", "legend", "label", "select", "option", "hr"});
        if (options.getParagraphOnBr()) {
            this.defineParagraphTag("br");
        }
        this.defineShortcut("br", "br");
        this.definePreformatTags(new String[]{"textarea", "pre"});
        this.defineIntactTags(new String[]{"style", "script", "object", "embed"});
        this.defineTranslatableAttributes(new String[]{"abbr", "alt", "content", "summary", "title", "placeholder"});
        if (options.getTranslateHref()) {
            this.defineTranslatableAttribute("href");
        }
        if (options.getTranslateSrc()) {
            this.defineTranslatableTagAttribute("img", "src");
        }
        if (options.getTranslateLang()) {
            this.defineTranslatableAttributes(new String[]{"lang", "xml:lang"});
        }
        if (options.getTranslateHreflang()) {
            this.defineTranslatableAttribute("hreflang");
        }
        if ((this.translateValue = Boolean.valueOf(options.getTranslateValue())).booleanValue() || (this.translateButtonValue = Boolean.valueOf(options.getTranslateButtonValue())).booleanValue()) {
            this.defineTranslatableTagAttribute("input", "value");
        }
        if (!StringUtil.isEmpty(skipRegExp = options.getSkipRegExp())) {
            try {
                this.skipRegExpPattern = Pattern.compile(skipRegExp, 2);
            }
            catch (PatternSyntaxException e) {
                Log.log(e);
            }
        }
        String skipMetaString = options.getSkipMeta();
        this.skipMetaAttributes = new HashMap();
        String[] skipMetaAttributesStringarray = skipMetaString.split(",");
        for (int i = 0; i < skipMetaAttributesStringarray.length; ++i) {
            String keyvalue = skipMetaAttributesStringarray[i].trim().toUpperCase(Locale.ENGLISH);
            this.skipMetaAttributes.put(keyvalue, "");
        }
        String ignoreTagsString = options.getIgnoreTags();
        this.ignoreTagsAttributes = new HashMap();
        String[] ignoreTagsAttributesStringarray = ignoreTagsString.split(",");
        for (int i = 0; i < ignoreTagsAttributesStringarray.length; ++i) {
            String keyvalue = ignoreTagsAttributesStringarray[i].trim().toUpperCase(Locale.ENGLISH);
            this.ignoreTagsAttributes.put(keyvalue, "");
        }
    }

    @Override
    public Boolean validateTranslatableTagAttribute(String tag, String attribute, Attributes atts) {
        if ("INPUT".equalsIgnoreCase(tag) && attribute.equalsIgnoreCase("value")) {
            if (this.translateValue.booleanValue()) {
                return true;
            }
            if (this.translateButtonValue.booleanValue()) {
                for (int i = 0; i < atts.size(); ++i) {
                    Attribute otherAttribute = atts.get(i);
                    if (!"type".equalsIgnoreCase(otherAttribute.getName()) || !"button".equalsIgnoreCase(otherAttribute.getValue()) && !"submit".equalsIgnoreCase(otherAttribute.getValue()) && !"reset".equalsIgnoreCase(otherAttribute.getValue())) continue;
                    return super.validateTranslatableTagAttribute(tag, attribute, atts);
                }
                return false;
            }
            return super.validateTranslatableTagAttribute(tag, attribute, atts);
        }
        if ("META".equalsIgnoreCase(tag) && "content".equalsIgnoreCase(attribute)) {
            boolean doSkipMetaTag = false;
            for (int i = 0; i < atts.size(); ++i) {
                Attribute otherAttribute = atts.get(i);
                String name = otherAttribute.getName();
                String value = otherAttribute.getValue();
                if (name != null && value != null && (doSkipMetaTag = this.checkDoSkipMetaTag(name, value))) break;
            }
            if (doSkipMetaTag) {
                return false;
            }
            return super.validateTranslatableTagAttribute(tag, attribute, atts);
        }
        return super.validateTranslatableTagAttribute(tag, attribute, atts);
    }

    public Pattern getSkipRegExpPattern() {
        return this.skipRegExpPattern;
    }

    public HashMap<String, String> getSkipMetaAttributes() {
        return this.skipMetaAttributes;
    }

    public boolean checkDoSkipMetaTag(String key, String value) {
        return this.skipMetaAttributes.containsKey(key.toUpperCase(Locale.ENGLISH) + "=" + value.toUpperCase(Locale.ENGLISH));
    }

    private boolean checkIgnoreTags(String key, String value) {
        return this.ignoreTagsAttributes.containsKey(key.toUpperCase(Locale.ENGLISH) + "=" + value.toUpperCase(Locale.ENGLISH));
    }

    @Override
    public Boolean validateIntactTag(String tag, Attributes atts) {
        if (atts != null) {
            for (int i = 0; i < atts.size(); ++i) {
                Attribute oneAttribute = atts.get(i);
                if (!this.checkIgnoreTags(oneAttribute.getName(), oneAttribute.getValue())) continue;
                return true;
            }
        }
        return false;
    }
}

