/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.tail.index;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.trie4j.bv.LongsRank1OnlySuccinctBitVector;
import org.trie4j.bv.SuccinctBitVector;
import org.trie4j.tail.index.TailIndex;

public class DenseArrayTailIndex
implements Externalizable,
TailIndex {
    private SuccinctBitVector sbv = new LongsRank1OnlySuccinctBitVector();
    private int[] tail = new int[0];

    public DenseArrayTailIndex() {
    }

    public DenseArrayTailIndex(int[] tail, byte[] bits, int bitsSize) {
        this.sbv = new LongsRank1OnlySuccinctBitVector(bits, bitsSize);
        this.tail = tail;
    }

    public DenseArrayTailIndex(SuccinctBitVector sbv, int[] tail) {
        this.sbv = sbv;
        this.tail = tail;
    }

    public SuccinctBitVector getSbv() {
        return this.sbv;
    }

    public void setSbv(SuccinctBitVector sbv) {
        this.sbv = sbv;
    }

    public int[] getTail() {
        return this.tail;
    }

    public void setTail(int[] tail) {
        this.tail = tail;
    }

    @Override
    public int size() {
        return this.sbv.size();
    }

    @Override
    public int get(int nodeId) {
        if (this.sbv.isZero(nodeId)) {
            return -1;
        }
        return this.tail[this.sbv.rank1(nodeId) - 1];
    }

    @Override
    public void readExternal(ObjectInput in) throws ClassNotFoundException, IOException {
        this.sbv = (SuccinctBitVector)in.readObject();
        this.tail = (int[])in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.sbv);
        out.writeObject(this.tail);
    }
}

