/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.issues;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.omegat.core.Core;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.gui.issues.IIssue;
import org.omegat.gui.issues.IIssueProvider;
import org.omegat.gui.issues.IssueDetailSplitPanel;
import org.omegat.gui.issues.SimpleColorIcon;
import org.omegat.util.FileUtil;
import org.omegat.util.OStrings;
import org.omegat.util.Token;
import org.omegat.util.gui.Styles;

class TerminologyIssueProvider
implements IIssueProvider {
    TerminologyIssueProvider() {
    }

    @Override
    public String getName() {
        return OStrings.getString("ISSUES_TERMINOLOGY_PROVIDER_NAME");
    }

    @Override
    public String getId() {
        return this.getClass().getCanonicalName();
    }

    @Override
    public List<IIssue> getIssues(SourceTextEntry sourceEntry, TMXEntry tmxEntry) {
        List<GlossaryEntry> entries = Core.getGlossaryManager().searchSourceMatches(sourceEntry);
        if (entries.isEmpty()) {
            return Collections.emptyList();
        }
        return entries.stream().map(e -> {
            List<String> trgTerms = Core.getGlossaryManager().searchTargetMatches(tmxEntry.translation, sourceEntry.getProtectedParts(), (GlossaryEntry)e);
            return trgTerms.isEmpty() ? new TerminologyIssue(sourceEntry, tmxEntry, (GlossaryEntry)e) : null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static String normalizePath(String path) {
        return path.replace('\\', '/');
    }

    private static String trimPrefix(String str, String prefix) {
        return str.startsWith(prefix) ? str.substring(prefix.length()) : str;
    }

    static class TerminologyIssue
    implements IIssue {
        private static final Icon ICON = new SimpleColorIcon(Styles.EditorColor.COLOR_TERMINOLOGY.getColor());
        private static final AttributeSet ERROR_STYLE;
        private final SourceTextEntry ste;
        private final TMXEntry tmxEntry;
        private final GlossaryEntry glossaryEntry;

        TerminologyIssue(SourceTextEntry ste, TMXEntry tmxEntry, GlossaryEntry glossaryEntry) {
            this.ste = ste;
            this.tmxEntry = tmxEntry;
            this.glossaryEntry = glossaryEntry;
        }

        @Override
        public Icon getIcon() {
            return ICON;
        }

        @Override
        public String getTypeName() {
            return OStrings.getString("ISSUES_TERMINOLOGY_TYPE");
        }

        @Override
        public int getSegmentNumber() {
            return this.ste.entryNum();
        }

        @Override
        public String getDescription() {
            String[] origins = this.glossaryEntry.getOrigins(false);
            String[] targetTerms = this.glossaryEntry.getLocTerms(false);
            if (targetTerms.length == 1) {
                String origin = FileUtil.getUniqueNames(Arrays.asList(origins[0])).get(0);
                return OStrings.getString("ISSUES_TERMINOLOGY_DESCRIPTION", origin, this.glossaryEntry.getSrcText(), targetTerms[0]);
            }
            String tDelim = OStrings.getString("ISSUES_TERMINOLOGY_TERM_DELIMITER");
            String oDelim = OStrings.getString("ISSUES_TERMINOLOGY_ORIGIN_DELIMITER");
            String[] uniqueOrigins = this.glossaryEntry.getOrigins(true);
            String[] uniqueTerms = this.glossaryEntry.getLocTerms(true);
            if (uniqueTerms.length == 1) {
                String origin = String.join((CharSequence)oDelim, FileUtil.getUniqueNames(Arrays.asList(uniqueOrigins)));
                return OStrings.getString("ISSUES_TERMINOLOGY_DESCRIPTION", origin, this.glossaryEntry.getSrcText(), uniqueTerms[0]);
            }
            if (uniqueOrigins.length == 1) {
                List<String> formattedTerms = Arrays.asList(uniqueTerms);
                formattedTerms.replaceAll(t -> OStrings.getString("ISSUES_TERMINOLOGY_TERM_TEMPLATE", t));
                String origin = FileUtil.getUniqueNames(Arrays.asList(uniqueOrigins[0])).get(0);
                return OStrings.getString("ISSUES_TERMINOLOGY_DESCRIPTION_MULTI", origin, this.glossaryEntry.getSrcText(), String.join((CharSequence)tDelim, formattedTerms));
            }
            List<String> uniqueOriginsList = Arrays.asList(uniqueOrigins);
            String iDelim = OStrings.getString("ISSUES_TERMINOLOGY_TERM_ORIGIN_INDEX_DELIMITER");
            String originStr = String.join((CharSequence)oDelim, FileUtil.getUniqueNames(uniqueOriginsList));
            ArrayList<String> formattedTerms = new ArrayList<String>(uniqueTerms.length);
            for (int i = 0; i < uniqueTerms.length; ++i) {
                Object origin;
                String term = uniqueTerms[i];
                ArrayList<Object> termOrigins = new ArrayList<Object>(uniqueOrigins.length);
                for (int j = 0; j < targetTerms.length; ++j) {
                    if (!term.equals(targetTerms[j]) || termOrigins.contains(origin = origins[j])) continue;
                    termOrigins.add(origin);
                }
                ArrayList<Integer> originIndices = new ArrayList<Integer>(uniqueOrigins.length);
                origin = termOrigins.iterator();
                while (origin.hasNext()) {
                    String origin2 = (String)origin.next();
                    int index = uniqueOriginsList.indexOf(origin2) + 1;
                    originIndices.add(index);
                }
                originIndices.sort(Comparator.naturalOrder());
                ArrayList indexStrings = new ArrayList(originIndices.size());
                originIndices.forEach(idx -> indexStrings.add(String.valueOf(idx)));
                formattedTerms.add(OStrings.getString("ISSUES_TERMINOLOGY_TERM_MULTIORIGIN_TEMPLATE", term, String.join((CharSequence)iDelim, indexStrings)));
            }
            return OStrings.getString("ISSUES_TERMINOLOGY_DESCRIPTION_MULTI", originStr, this.glossaryEntry.getSrcText(), String.join((CharSequence)tDelim, formattedTerms));
        }

        @Override
        public Component getDetailComponent() {
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.add(this.getSplitPanel(), "Center");
            panel.add(this.getOriginLabel(), "South");
            return panel;
        }

        private Component getSplitPanel() {
            IssueDetailSplitPanel splitPanel = new IssueDetailSplitPanel();
            splitPanel.firstTextPane.setText(this.ste.getSrcText());
            splitPanel.lastTextPane.setText(this.tmxEntry.translation);
            StyledDocument doc = splitPanel.firstTextPane.getStyledDocument();
            for (Token[] toks : Core.getGlossaryManager().searchSourceMatchTokens(this.ste, this.glossaryEntry)) {
                for (Token tok : toks) {
                    doc.setCharacterAttributes(tok.getOffset(), tok.getLength(), ERROR_STYLE, false);
                }
            }
            splitPanel.setMinimumSize(new Dimension(0, splitPanel.firstTextPane.getFont().getSize() * 6));
            return splitPanel;
        }

        private Component getOriginLabel() {
            String originDesc;
            String delim = OStrings.getString("ISSUES_TERMINOLOGY_ORIGIN_DETAIL_DELIMITER");
            String tDelim = OStrings.getString("ISSUES_TERMINOLOGY_TERM_DELIMITER");
            String[] origins = this.glossaryEntry.getOrigins(true);
            String glossariesDir = Core.getProject().getProjectProperties().getGlossaryDir().getAsString();
            if (origins.length == 1) {
                String origin = TerminologyIssueProvider.trimPrefix(TerminologyIssueProvider.normalizePath(origins[0]), glossariesDir);
                originDesc = OStrings.getString("ISSUES_TERMINOLOGY_ORIGINS", this.glossaryEntry.getSrcText(), OStrings.getString("ISSUES_TERMINOLOGY_ORIGIN_DETAIL_TEMPLATE", 1, origin, String.join((CharSequence)tDelim, this.glossaryEntry.getLocTerms(true))));
            } else {
                ArrayList<String> formattedOrigins = new ArrayList<String>(origins.length);
                String[] allOrigins = this.glossaryEntry.getOrigins(false);
                String[] allTerms = this.glossaryEntry.getLocTerms(false);
                for (int i = 0; i < origins.length; ++i) {
                    ArrayList<String> termsFromThisOrigin = new ArrayList<String>();
                    if (allOrigins.length == allTerms.length) {
                        for (int j = 0; j < allOrigins.length; ++j) {
                            if (!allOrigins[j].equals(origins[i]) || termsFromThisOrigin.contains(allTerms[j])) continue;
                            termsFromThisOrigin.add(allTerms[j]);
                        }
                    }
                    String origin = TerminologyIssueProvider.trimPrefix(TerminologyIssueProvider.normalizePath(origins[i]), glossariesDir);
                    formattedOrigins.add(OStrings.getString("ISSUES_TERMINOLOGY_ORIGIN_DETAIL_TEMPLATE", i + 1, origin, String.join((CharSequence)tDelim, termsFromThisOrigin)));
                }
                originDesc = OStrings.getString("ISSUES_TERMINOLOGY_ORIGINS", this.glossaryEntry.getSrcText(), String.join((CharSequence)delim, formattedOrigins));
            }
            JLabel originLabel = new JLabel(originDesc);
            originLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), originLabel.getBorder()));
            return originLabel;
        }

        static {
            SimpleAttributeSet attr = new SimpleAttributeSet();
            StyleConstants.setForeground(attr, Styles.EditorColor.COLOR_TERMINOLOGY.getColor());
            StyleConstants.setBold(attr, true);
            ERROR_STYLE = attr;
        }
    }
}

