/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.eclipse.jgit.util.FS;

public class FileSnapshot {
    public static final long UNKNOWN_SIZE = -1L;
    public static final FileSnapshot DIRTY = new FileSnapshot(-1L, -1L, -1L);
    public static final FileSnapshot MISSING_FILE = new FileSnapshot(0L, 0L, 0L){

        @Override
        public boolean isModified(File path) {
            return FS.DETECTED.exists(path);
        }
    };
    private final long lastModified;
    private volatile long lastRead;
    private boolean cannotBeRacilyClean;
    private final long size;

    public static FileSnapshot save(File path) {
        long size;
        long modified;
        long read = System.currentTimeMillis();
        try {
            BasicFileAttributes fileAttributes = FS.DETECTED.fileAttributes(path);
            modified = fileAttributes.lastModifiedTime().toMillis();
            size = fileAttributes.size();
        }
        catch (IOException e) {
            modified = path.lastModified();
            size = path.length();
        }
        return new FileSnapshot(read, modified, size);
    }

    public static FileSnapshot save(long modified) {
        long read = System.currentTimeMillis();
        return new FileSnapshot(read, modified, -1L);
    }

    private FileSnapshot(long read, long modified, long size) {
        this.lastRead = read;
        this.lastModified = modified;
        this.cannotBeRacilyClean = this.notRacyClean(read);
        this.size = size;
    }

    public long lastModified() {
        return this.lastModified;
    }

    public long size() {
        return this.size;
    }

    public boolean isModified(File path) {
        long currSize;
        long currLastModified;
        try {
            BasicFileAttributes fileAttributes = FS.DETECTED.fileAttributes(path);
            currLastModified = fileAttributes.lastModifiedTime().toMillis();
            currSize = fileAttributes.size();
        }
        catch (IOException e) {
            currLastModified = path.lastModified();
            currSize = path.length();
        }
        return currSize != -1L && currSize != this.size || this.isModified(currLastModified);
    }

    public void setClean(FileSnapshot other) {
        long now = other.lastRead;
        if (this.notRacyClean(now)) {
            this.cannotBeRacilyClean = true;
        }
        this.lastRead = now;
    }

    public boolean equals(FileSnapshot other) {
        return this.lastModified == other.lastModified;
    }

    public boolean equals(Object other) {
        if (other instanceof FileSnapshot) {
            return this.equals((FileSnapshot)other);
        }
        return false;
    }

    public int hashCode() {
        return (int)this.lastModified;
    }

    public String toString() {
        if (this == DIRTY) {
            return "DIRTY";
        }
        if (this == MISSING_FILE) {
            return "MISSING_FILE";
        }
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.US);
        return "FileSnapshot[modified: " + f.format(new Date(this.lastModified)) + ", read: " + f.format(new Date(this.lastRead)) + "]";
    }

    private boolean notRacyClean(long read) {
        return read - this.lastModified > 2500L;
    }

    private boolean isModified(long currLastModified) {
        if (this.lastModified != currLastModified) {
            return true;
        }
        if (this.cannotBeRacilyClean) {
            return false;
        }
        return !this.notRacyClean(this.lastRead);
    }
}

