/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.data;

import java.util.ArrayList;
import java.util.List;
import org.omegat.core.Core;
import org.omegat.core.data.IProject;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.data.ProtectedPart;
import org.omegat.core.segmentation.Rule;
import org.omegat.filters2.IFilter;
import org.omegat.filters2.IParseCallback;
import org.omegat.util.Language;
import org.omegat.util.PatternConsts;
import org.omegat.util.StringUtil;

public abstract class ParseEntry
implements IParseCallback {
    private final ProjectProperties config;
    private List<ParseEntryQueueItem> parseQueue = new ArrayList<ParseEntryQueueItem>();

    public ParseEntry(ProjectProperties conf) {
        this.config = conf;
    }

    protected void setCurrentFile(IProject.FileInfo fi) {
    }

    protected void fileFinished() {
        for (ParseEntryQueueItem item : this.parseQueue) {
            this.addSegment(item.id, item.segmentIndex, item.segmentSource, item.protectedParts, item.segmentTranslation, item.segmentTranslationFuzzy, item.props, item.prevSegment, item.nextSegment, item.path);
        }
        this.parseQueue.clear();
    }

    @Override
    public void linkPrevNextSegments() {
        for (int i = 0; i < this.parseQueue.size(); ++i) {
            ParseEntryQueueItem item = this.parseQueue.get(i);
            try {
                item.prevSegment = this.parseQueue.get((int)(i - 1)).segmentSource;
            }
            catch (IndexOutOfBoundsException ex) {
                item.prevSegment = "";
            }
            try {
                item.nextSegment = this.parseQueue.get((int)(i + 1)).segmentSource;
                continue;
            }
            catch (IndexOutOfBoundsException ex) {
                item.nextSegment = "";
            }
        }
    }

    @Override
    public void addEntryWithProperties(String id, String source, String translation, boolean isFuzzy, String[] props, String path, IFilter filter, List<ProtectedPart> protectedParts) {
        if (StringUtil.isEmpty(source)) {
            return;
        }
        if (props != null && props.length % 2 != 0) {
            throw new IllegalArgumentException("Entry properties must be in a key=value array with an even number of items.");
        }
        ParseEntryResult tmp = new ParseEntryResult();
        boolean removeSpaces = Core.getFilterMaster().getConfig().isRemoveSpacesNonseg();
        source = ParseEntry.stripSomeChars(source, tmp, this.config.isRemoveTags(), removeSpaces);
        source = StringUtil.normalizeUnicode(source);
        if (this.config.isRemoveTags() && protectedParts != null) {
            for (int i = 0; i < protectedParts.size(); ++i) {
                ProtectedPart p = protectedParts.get(i);
                String s = p.getTextInSourceSegment();
                if ((s = PatternConsts.OMEGAT_TAG.matcher(s).replaceAll("")).isEmpty()) {
                    protectedParts.remove(i);
                    --i;
                    continue;
                }
                p.setTextInSourceSegment(s);
            }
        }
        if (translation != null) {
            translation = ParseEntry.stripSomeChars(translation, tmp, this.config.isRemoveTags(), removeSpaces);
            translation = StringUtil.normalizeUnicode(translation);
        }
        if (this.config.isSentenceSegmentingEnabled()) {
            ArrayList<StringBuilder> spaces = new ArrayList<StringBuilder>();
            ArrayList<Rule> brules = new ArrayList<Rule>();
            Language sourceLang = this.config.getSourceLanguage();
            List<String> segments = Core.getSegmenter().segment(sourceLang, source, spaces, brules);
            if (segments.size() == 1) {
                this.internalAddSegment(id, (short)0, segments.get(0), translation, isFuzzy, props, path, protectedParts);
            } else {
                for (short i = 0; i < segments.size(); i = (short)(i + 1)) {
                    String onesrc = segments.get(i);
                    List<ProtectedPart> segmentProtectedParts = ProtectedPart.extractFor(protectedParts, onesrc);
                    this.internalAddSegment(id, i, onesrc, null, false, props, path, segmentProtectedParts);
                }
            }
        } else {
            this.internalAddSegment(id, (short)0, source, translation, isFuzzy, props, path, protectedParts);
        }
    }

    @Override
    public void addEntry(String id, String source, String translation, boolean isFuzzy, String comment, String path, IFilter filter, List<ProtectedPart> protectedParts) {
        String[] stringArray;
        if (comment == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "comment";
            stringArray = stringArray2;
            stringArray2[1] = comment;
        }
        String[] props = stringArray;
        this.addEntryWithProperties(id, source, translation, isFuzzy, props, path, filter, protectedParts);
    }

    @Override
    public void addEntry(String id, String source, String translation, boolean isFuzzy, String comment, IFilter filter) {
        this.addEntry(id, source, translation, isFuzzy, comment, null, filter, null);
    }

    private void internalAddSegment(String id, short segmentIndex, String segmentSource, String segmentTranslation, boolean segmentTranslationFuzzy, String[] props, String path, List<ProtectedPart> protectedParts) {
        if (segmentSource.trim().isEmpty()) {
            return;
        }
        ParseEntryQueueItem item = new ParseEntryQueueItem();
        item.id = id;
        item.segmentIndex = segmentIndex;
        item.segmentSource = segmentSource;
        item.protectedParts = protectedParts;
        item.segmentTranslation = segmentTranslation;
        item.segmentTranslationFuzzy = segmentTranslationFuzzy;
        item.props = props;
        item.path = path;
        this.parseQueue.add(item);
    }

    protected abstract void addSegment(String var1, short var2, String var3, List<ProtectedPart> var4, String var5, boolean var6, String[] var7, String var8, String var9, String var10);

    public static String stripSomeChars(String src, ParseEntryResult per, boolean removeTags, boolean removeSpaces) {
        int e;
        int b;
        String r = src;
        int len = r.length();
        if (removeSpaces) {
            int cp;
            for (b = 0; b < len && (Character.isWhitespace(cp = r.codePointAt(b)) || cp == 160); b += Character.charCount(cp)) {
            }
        }
        per.spacesAtBegin = b;
        if (removeSpaces) {
            int cp;
            for (e = len; e > b && (Character.isWhitespace(cp = r.codePointBefore(e)) || cp == 160); e -= Character.charCount(cp)) {
            }
        }
        per.spacesAtEnd = len - e;
        boolean bl = per.crlf = (r = r.substring(b, e)).indexOf("\r\n") > 0;
        if (per.crlf) {
            r = r.replace("\r\n", "\n");
        }
        boolean bl2 = per.cr = r.indexOf("\r") > 0;
        if (per.cr) {
            r = r.replace("\r", "\n");
        }
        if (removeTags) {
            r = PatternConsts.OMEGAT_TAG.matcher(r).replaceAll("");
        }
        r = StringUtil.removeXMLInvalidChars(r);
        return r;
    }

    protected static class ParseEntryQueueItem {
        String id;
        short segmentIndex;
        String segmentSource;
        List<ProtectedPart> protectedParts;
        String segmentTranslation;
        boolean segmentTranslationFuzzy;
        String[] props;
        String prevSegment;
        String nextSegment;
        String path;

        protected ParseEntryQueueItem() {
        }
    }

    public static class ParseEntryResult {
        public boolean crlf;
        public boolean cr;
        int spacesAtBegin;
        int spacesAtEnd;
    }
}

