/*
 * Decompiled with CFR 0.152.
 */
package org.madlonkay.supertmxmerge.data;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.madlonkay.supertmxmerge.data.ITmx;
import org.madlonkay.supertmxmerge.data.ITu;
import org.madlonkay.supertmxmerge.data.ITuv;
import org.madlonkay.supertmxmerge.data.Key;
import org.madlonkay.supertmxmerge.data.MergeAnalysis;

public class ResolutionSet {
    public final Set<Key> toDelete;
    public final Map<Key, ITu> toAdd;
    public final Map<Key, ITuv> toReplace;

    public static ResolutionSet fromAnalysis(MergeAnalysis<Key, ITuv> analysis, ITmx leftTmx, ITmx rightTmx) {
        HashSet<Key> toDelete = new HashSet<Key>(analysis.deleted);
        HashMap<Key, ITu> toAdd = new HashMap<Key, ITu>();
        HashMap<Key, ITuv> toReplace = new HashMap<Key, ITuv>(analysis.modified);
        for (Key key : analysis.added) {
            ITu leftTuv = leftTmx.getTu(key);
            if (leftTuv != null) {
                toAdd.put(key, leftTuv);
                continue;
            }
            ITu rightTuv = rightTmx.getTu(key);
            assert (rightTuv != null);
            toAdd.put(key, rightTuv);
        }
        return new ResolutionSet(toDelete, toAdd, toReplace);
    }

    public static ResolutionSet unmodifiableSet(ResolutionSet set) {
        return new ResolutionSet(Collections.unmodifiableSet(set.toDelete), Collections.unmodifiableMap(set.toAdd), Collections.unmodifiableMap(set.toReplace));
    }

    private ResolutionSet(Set<Key> toDelete, Map<Key, ITu> toAdd, Map<Key, ITuv> toReplace) {
        this.toDelete = toDelete;
        this.toAdd = toAdd;
        this.toReplace = toReplace;
    }
}

