/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.bv;

import java.io.DataInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.trie4j.bv.BitVector;

public class BitVector01Divider
implements Externalizable {
    private transient BitVector r0;
    private transient BitVector r1;
    private boolean first = true;
    private boolean zeroCounting;

    public BitVector01Divider() {
    }

    public BitVector01Divider(BitVector r0, BitVector r1) {
        this.r0 = r0;
        this.r1 = r1;
    }

    public BitVector01Divider(boolean first, boolean zeroCounting) {
        this.first = first;
        this.zeroCounting = zeroCounting;
    }

    public boolean isFirst() {
        return this.first;
    }

    public boolean isZeroCounting() {
        return this.zeroCounting;
    }

    public void setVectors(BitVector r0, BitVector r1) {
        this.r0 = r0;
        this.r1 = r1;
    }

    public void append0() {
        if (this.first) {
            this.firstProc(false);
            return;
        }
        if (this.zeroCounting) {
            this.r0.append1();
        } else {
            this.r1.append0();
            this.zeroCounting = true;
        }
    }

    public void append1() {
        if (this.first) {
            this.firstProc(true);
            return;
        }
        if (this.zeroCounting) {
            this.r0.append0();
            this.zeroCounting = false;
        } else {
            this.r1.append1();
        }
    }

    private void firstProc(boolean b) {
        this.zeroCounting = !b;
        this.r0.append0();
        this.r1.append0();
        this.first = false;
    }

    @Override
    public void readExternal(ObjectInput in) throws ClassNotFoundException, IOException {
        this.first = in.readBoolean();
        this.zeroCounting = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this.first);
        out.writeBoolean(this.zeroCounting);
    }

    public void readFrom(InputStream is) throws IOException {
        DataInputStream dis = new DataInputStream(is);
        this.first = dis.readBoolean();
        this.zeroCounting = dis.readBoolean();
    }
}

