/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.html2;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import org.omegat.filters2.html2.HTMLOptions;
import org.omegat.util.PatternConsts;

public class HTMLWriter
extends Writer {
    private StringWriter writer;
    private BufferedWriter realWriter;
    private String htmlMeta;
    private String xmlHeader;
    private String encoding;
    private HTMLOptions options;
    private static final int MIN_HEADERED_BUFFER_SIZE = 4096;
    private static final int MAX_BUFFER_SIZE = 65536;
    private boolean signalClosing = false;
    private boolean signalAlreadyFlushed = false;

    public HTMLWriter(String fileName, String encoding, HTMLOptions options) throws FileNotFoundException, UnsupportedEncodingException {
        this.encoding = encoding;
        this.options = options;
        this.writer = new StringWriter();
        FileOutputStream fos = new FileOutputStream(fileName);
        OutputStreamWriter osw = encoding != null ? new OutputStreamWriter((OutputStream)fos, encoding) : new OutputStreamWriter((OutputStream)fos, Charset.defaultCharset());
        this.realWriter = new BufferedWriter(osw);
    }

    @Override
    public void close() throws IOException {
        this.signalClosing = true;
        this.flush();
        this.realWriter.close();
    }

    @Override
    public void flush() throws IOException {
        StringBuffer buffer = this.writer.getBuffer();
        if (this.signalAlreadyFlushed || this.encoding == null) {
            this.realWriter.write(buffer.toString());
            buffer.setLength(0);
        } else if (this.signalClosing || buffer.length() >= 4096) {
            this.signalAlreadyFlushed = true;
            String contents = buffer.toString();
            if (this.options.getRewriteEncoding() != HTMLOptions.REWRITE_MODE.NEVER) {
                Matcher matcherHeader = PatternConsts.XML_HEADER.matcher(contents);
                boolean xhtml = false;
                if (matcherHeader.find()) {
                    this.xmlHeader = "<?xml version=\"1.0\" encoding=\"" + this.encoding + "\"?>";
                    contents = matcherHeader.replaceFirst(this.xmlHeader);
                    xhtml = true;
                }
                this.htmlMeta = "<meta http-equiv=\"content-type\" content=\"text/html; charset=" + this.encoding + "\"";
                this.htmlMeta = xhtml ? this.htmlMeta + " />" : this.htmlMeta + ">";
                Matcher matcherEnc = PatternConsts.HTML_ENCODING.matcher(contents);
                if (matcherEnc.find()) {
                    contents = matcherEnc.replaceFirst(this.htmlMeta);
                } else if (this.options.getRewriteEncoding() != HTMLOptions.REWRITE_MODE.IFMETA) {
                    Matcher matcherHead = PatternConsts.HTML_HEAD.matcher(contents);
                    if (matcherHead.find()) {
                        contents = matcherHead.replaceFirst("<head>\n    " + this.htmlMeta);
                    } else if (this.options.getRewriteEncoding() != HTMLOptions.REWRITE_MODE.IFHEADER) {
                        Matcher matcherHtml = PatternConsts.HTML_HTML.matcher(contents);
                        contents = matcherHtml.find() ? matcherHtml.replaceFirst("<html>\n<head>\n    " + this.htmlMeta + "\n</head>\n") : "<html>\n<head>\n    " + this.htmlMeta + "\n</head>\n" + contents;
                    }
                }
            }
            this.realWriter.write(contents);
            buffer.setLength(0);
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.writer.write(cbuf, off, len);
        if (this.writer.getBuffer().length() >= 65536) {
            this.flush();
        }
    }
}

