/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.parser.chunking;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.ml.model.Event;
import opennlp.tools.parser.AbstractBottomUpParser;
import opennlp.tools.parser.AbstractParserEventStream;
import opennlp.tools.parser.HeadRules;
import opennlp.tools.parser.Parse;
import opennlp.tools.parser.ParseSampleStream;
import opennlp.tools.parser.ParserEventTypeEnum;
import opennlp.tools.parser.chunking.BuildContextGenerator;
import opennlp.tools.parser.chunking.CheckContextGenerator;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;

public class ParserEventStream
extends AbstractParserEventStream {
    protected BuildContextGenerator bcg;
    protected CheckContextGenerator kcg;

    public ParserEventStream(ObjectStream<Parse> d, HeadRules rules, ParserEventTypeEnum etype, Dictionary dict) {
        super(d, rules, etype, dict);
    }

    @Override
    protected void init() {
        if (this.etype == ParserEventTypeEnum.BUILD) {
            this.bcg = new BuildContextGenerator(this.dict);
        } else if (this.etype == ParserEventTypeEnum.CHECK) {
            this.kcg = new CheckContextGenerator();
        }
    }

    public ParserEventStream(ObjectStream<Parse> d, HeadRules rules, ParserEventTypeEnum etype) {
        this(d, rules, etype, null);
    }

    protected boolean firstChild(Parse child, Parse parent) {
        return AbstractBottomUpParser.collapsePunctuation(parent.getChildren(), this.punctSet)[0] == child;
    }

    public static Parse[] reduceChunks(Parse[] chunks, int ci, Parse parent) {
        Parse[] reducedChunks;
        int reduceStart;
        String type = parent.getType();
        int reduceEnd = ci;
        for (reduceStart = ci; reduceStart >= 0 && chunks[reduceStart].getParent() == parent; --reduceStart) {
        }
        ++reduceStart;
        if (!type.equals("TOP")) {
            int ri;
            reducedChunks = new Parse[chunks.length - (reduceEnd - reduceStart + 1) + 1];
            int rn = reduceStart;
            for (ri = 0; ri < rn; ++ri) {
                reducedChunks[ri] = chunks[ri];
            }
            reducedChunks[reduceStart] = parent;
            parent.setPrevPunctuation(chunks[reduceStart].getPreviousPunctuationSet());
            parent.setNextPunctuation(chunks[reduceEnd].getNextPunctuationSet());
            ri = reduceStart + 1;
            for (int rci = reduceEnd + 1; rci < chunks.length; ++rci) {
                reducedChunks[ri] = chunks[rci];
                ++ri;
            }
            ci = reduceStart - 1;
        } else {
            reducedChunks = new Parse[]{};
        }
        return reducedChunks;
    }

    @Override
    protected void addParseEvents(List<Event> parseEvents, Parse[] chunks) {
        for (int ci = 0; ci < chunks.length; ++ci) {
            int start;
            Parse c = chunks[ci];
            Parse parent = c.getParent();
            if (parent == null) continue;
            String type = parent.getType();
            String outcome = this.firstChild(c, parent) ? "S-" + type : "C-" + type;
            c.setLabel(outcome);
            if (this.etype == ParserEventTypeEnum.BUILD) {
                parseEvents.add(new Event(outcome, this.bcg.getContext(chunks, ci)));
            }
            for (start = ci - 1; start >= 0 && chunks[start].getParent() == parent; --start) {
            }
            if (this.lastChild(c, parent)) {
                int reduceStart;
                if (this.etype == ParserEventTypeEnum.CHECK) {
                    parseEvents.add(new Event("c", this.kcg.getContext(chunks, type, start + 1, ci)));
                }
                for (reduceStart = ci; reduceStart >= 0 && chunks[reduceStart].getParent() == parent; --reduceStart) {
                }
                chunks = ParserEventStream.reduceChunks(chunks, ci, parent);
                ci = ++reduceStart - 1;
                continue;
            }
            if (this.etype != ParserEventTypeEnum.CHECK) continue;
            parseEvents.add(new Event("i", this.kcg.getContext(chunks, type, start + 1, ci)));
        }
    }

    public static void main(String[] args) throws IOException, InvalidFormatException {
        Event event;
        int ai;
        if (args.length == 0) {
            System.err.println("Usage ParserEventStream -[tag|chunk|build|check|fun] head_rules [dictionary] < parses");
            System.exit(1);
        }
        ParserEventTypeEnum etype = null;
        boolean fun = false;
        for (ai = 0; ai < args.length && args[ai].startsWith("-"); ++ai) {
            if (args[ai].equals("-build")) {
                etype = ParserEventTypeEnum.BUILD;
                continue;
            }
            if (args[ai].equals("-check")) {
                etype = ParserEventTypeEnum.CHECK;
                continue;
            }
            if (args[ai].equals("-chunk")) {
                etype = ParserEventTypeEnum.CHUNK;
                continue;
            }
            if (args[ai].equals("-tag")) {
                etype = ParserEventTypeEnum.TAG;
                continue;
            }
            if (args[ai].equals("-fun")) {
                fun = true;
                continue;
            }
            System.err.println("Invalid option " + args[ai]);
            System.exit(1);
        }
        opennlp.tools.parser.lang.en.HeadRules rules = new opennlp.tools.parser.lang.en.HeadRules(args[ai++]);
        Dictionary dict = null;
        if (ai < args.length) {
            dict = new Dictionary(new FileInputStream(args[ai++]), true);
        }
        if (fun) {
            Parse.useFunctionTags(true);
        }
        ParserEventStream es = new ParserEventStream(new ParseSampleStream(new PlainTextByLineStream(new InputStreamReader(System.in))), rules, etype, dict);
        while ((event = (Event)es.read()) != null) {
            System.out.println(event);
        }
    }
}

