/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.dialogs;

import java.awt.Desktop;
import java.awt.Window;
import java.io.IOException;
import java.net.URI;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import org.omegat.gui.dialogs.VersionCheckPanel;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.VersionChecker;
import org.omegat.util.gui.StaticUIUtils;

public class VersionCheckDialog {
    private static final String DOWNLOAD_URL = "https://omegat.org/download";
    private final String newVersion;

    public static void checkAndShowResultAsync(final Window parent) {
        new SwingWorker<Boolean, Void>(){

            @Override
            protected Boolean doInBackground() throws Exception {
                return VersionChecker.getInstance().isUpToDate(true);
            }

            @Override
            protected void done() {
                try {
                    if (((Boolean)this.get()).booleanValue()) {
                        JOptionPane.showMessageDialog(parent, OStrings.getString("VERSION_CHECK_UP_TO_DATE"));
                    } else {
                        new VersionCheckDialog(VersionChecker.getInstance().getRemoteVersion()).show(parent);
                    }
                }
                catch (Exception e) {
                    Log.logWarningRB("VERSION_CHECK_FAILED", e);
                    JOptionPane.showMessageDialog(parent, OStrings.getString("VERSION_CHECK_FAILED", e.getCause()), OStrings.getString("ERROR_TITLE"), 0);
                }
            }
        }.execute();
    }

    public VersionCheckDialog(String newVersion) {
        this.newVersion = newVersion;
    }

    public void show(Window parent) {
        JDialog dialog = new JDialog(parent);
        dialog.setDefaultCloseOperation(2);
        dialog.setModal(true);
        StaticUIUtils.setWindowIcon(dialog);
        StaticUIUtils.setEscapeClosable(dialog);
        VersionCheckPanel panel = new VersionCheckPanel();
        panel.message.setText(OStrings.getString("VERSION_CHECK_OUT_OF_DATE", this.newVersion, OStrings.getSimpleVersion()));
        panel.autoCheckCheckBox.setSelected(Preferences.isPreferenceDefault("automatically_check_version", true));
        panel.autoCheckCheckBox.addActionListener(e -> Preferences.setPreference("automatically_check_version", panel.autoCheckCheckBox.isSelected()));
        panel.goToDownloadsButton.addActionListener(e -> {
            try {
                Desktop.getDesktop().browse(URI.create(DOWNLOAD_URL));
                StaticUIUtils.closeWindowByEvent(dialog);
            }
            catch (IOException ex) {
                Log.log(ex);
                JOptionPane.showMessageDialog(parent, ex.getLocalizedMessage(), OStrings.getString("ERROR_TITLE"), 0);
            }
        });
        panel.cancelButton.addActionListener(e -> StaticUIUtils.closeWindowByEvent(dialog));
        dialog.getContentPane().add(panel);
        dialog.getRootPane().setDefaultButton(panel.goToDownloadsButton);
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
    }
}

