/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.image;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.filter.Filter;
import org.apache.pdfbox.filter.FilterFactory;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;

public final class LosslessFactory {
    private LosslessFactory() {
    }

    public static PDImageXObject createFromImage(PDDocument document, BufferedImage image) throws IOException {
        if (image.getType() == 10 && image.getColorModel().getPixelSize() <= 8 || image.getType() == 12 && image.getColorModel().getPixelSize() == 1) {
            return LosslessFactory.createFromGrayImage(image, document);
        }
        return LosslessFactory.createFromRGBImage(image, document);
    }

    private static PDImageXObject createFromGrayImage(BufferedImage image, PDDocument document) throws IOException {
        int height = image.getHeight();
        int width = image.getWidth();
        int[] rgbLineBuffer = new int[width];
        int bpc = image.getColorModel().getPixelSize();
        ByteArrayOutputStream baos = new ByteArrayOutputStream((width * bpc / 8 + (width * bpc % 8 != 0 ? 1 : 0)) * height);
        MemoryCacheImageOutputStream mcios = new MemoryCacheImageOutputStream(baos);
        for (int y = 0; y < height; ++y) {
            for (int pixel : image.getRGB(0, y, width, 1, rgbLineBuffer, 0, width)) {
                mcios.writeBits(pixel & 0xFF, bpc);
            }
            int bitOffset = mcios.getBitOffset();
            if (bitOffset == 0) continue;
            mcios.writeBits(0L, 8 - bitOffset);
        }
        mcios.flush();
        mcios.close();
        return LosslessFactory.prepareImageXObject(document, baos.toByteArray(), image.getWidth(), image.getHeight(), bpc, PDDeviceGray.INSTANCE);
    }

    private static PDImageXObject createFromRGBImage(BufferedImage image, PDDocument document) throws IOException {
        int apbc;
        int height = image.getHeight();
        int width = image.getWidth();
        int[] rgbLineBuffer = new int[width];
        int bpc = 8;
        PDDeviceRGB deviceColorSpace = PDDeviceRGB.INSTANCE;
        byte[] imageData = new byte[width * height * 3];
        int byteIdx = 0;
        int alphaByteIdx = 0;
        int alphaBitPos = 7;
        int transparency = image.getTransparency();
        int n = apbc = transparency == 2 ? 1 : 8;
        byte[] alphaImageData = transparency != 1 ? new byte[(width * apbc / 8 + (width * apbc % 8 != 0 ? 1 : 0)) * height] : new byte[]{};
        for (int y = 0; y < height; ++y) {
            for (int pixel : image.getRGB(0, y, width, 1, rgbLineBuffer, 0, width)) {
                imageData[byteIdx++] = (byte)(pixel >> 16 & 0xFF);
                imageData[byteIdx++] = (byte)(pixel >> 8 & 0xFF);
                imageData[byteIdx++] = (byte)(pixel & 0xFF);
                if (transparency == 1) continue;
                if (transparency == 2) {
                    int n2 = alphaByteIdx++;
                    alphaImageData[n2] = (byte)(alphaImageData[n2] | (pixel >> 24 & 1) << alphaBitPos);
                    if (--alphaBitPos >= 0) continue;
                    alphaBitPos = 7;
                    continue;
                }
                alphaImageData[alphaByteIdx++] = (byte)(pixel >> 24 & 0xFF);
            }
            if (transparency != 2 || alphaBitPos == 7) continue;
            alphaBitPos = 7;
            ++alphaByteIdx;
        }
        PDImageXObject pdImage = LosslessFactory.prepareImageXObject(document, imageData, image.getWidth(), image.getHeight(), bpc, deviceColorSpace);
        if (transparency != 1) {
            PDImageXObject pdMask = LosslessFactory.prepareImageXObject(document, alphaImageData, image.getWidth(), image.getHeight(), apbc, PDDeviceGray.INSTANCE);
            pdImage.getCOSObject().setItem(COSName.SMASK, (COSObjectable)pdMask);
        }
        return pdImage;
    }

    private static PDImageXObject prepareImageXObject(PDDocument document, byte[] byteArray, int width, int height, int bitsPerComponent, PDColorSpace initColorSpace) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(byteArray.length / 2);
        Filter filter = FilterFactory.INSTANCE.getFilter(COSName.FLATE_DECODE);
        filter.encode(new ByteArrayInputStream(byteArray), baos, new COSDictionary(), 0);
        ByteArrayInputStream encodedByteStream = new ByteArrayInputStream(baos.toByteArray());
        return new PDImageXObject(document, encodedByteStream, COSName.FLATE_DECODE, width, height, bitsPerComponent, initColorSpace);
    }
}

