//
//  CLMonth.m
//  DateLine
//
//  Created by Alex Clarke on 20/05/05.
//  Copyright 2005 CocoaLab. All rights reserved.
//

#import "CLManagedGraphic.h"
#import "CLMonth.h"
#import "NSBezierPath+CLExtensions.h"
#import "XMArgumentKeys.h"

@implementation CLMonth

- (id) init
{
	self = [super init];
	if (self != nil) {
		
	}
	return self;
}


-(void)drawInView:(NSView *)aView 
{
	NSUserDefaults * defaults = [NSUserDefaults standardUserDefaults];
	
	NSString * fontName = [defaults valueForKey:kXMTodayFontName];
	float fontSize = [[defaults valueForKey:kXMFontSize] floatValue];
	
	NSFont * font = [NSFont fontWithName:fontName size:fontSize];

	if ([defaults boolForKey:kXMDoDrawMonth]) {
		
		NSRect sourceRect = [aView bounds];
		hCentre = NSMidX(sourceRect);
		vCentre = NSMidY(sourceRect);
		float left = NSMinX(sourceRect);
		
		//  Fill our background rect
		NSColor * background = [self color];
		[background set]; 
		[NSBezierPath fillRoundRectInRect:sourceRect radius:6];	
		
		//  Draw shadow if we'll see it
		NSShadow * shadow = nil;
		if (shadowOffset > 0.00001)	
		{
			float shadowXOffset = sin(shadowAngle)*shadowOffset; 
			float shadowYOffset = cos(shadowAngle)*shadowOffset;
			shadow = [[NSShadow alloc] init];
			[shadow setShadowOffset: (NSMakeSize(shadowXOffset,shadowYOffset))];
			[shadow setShadowBlurRadius:shadowOffset];
			[shadow set];
		}		
		
		NSMutableDictionary * dayTextAttributes=[NSMutableDictionary dictionary];
		[dayTextAttributes setObject:font forKey:NSFontAttributeName];
		[dayTextAttributes setObject:[self textColor] forKey:NSForegroundColorAttributeName];
		
		//draw the month name label
		NSString * dayTextLabel=[[self valueForKey:@"today"] descriptionWithCalendarFormat:@"%B %Y" timeZone:nil locale:nil];
		float labelHLoc=left+4;
		float labelVLoc=vCentre-7.0;
		[dayTextLabel drawAtPoint:NSMakePoint(labelHLoc,labelVLoc)
				   withAttributes:dayTextAttributes];	
		
		//draw the shadow
		[shadow setShadowColor:nil]; [shadow set]; [shadow release];	
	}
}

- (BOOL)hitTest:(NSPoint)point isSelected:(BOOL)isSelected
{
    float hypotenuse2 = pow((xLoc-point.x), 2.0) + pow((yLoc-point.y), 2.0);
    return (hypotenuse2 < ((height) * (width)));
}


@end
