/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import java.io.File;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.gradle.internal.execution.OutputSnapshotter;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.WorkValidationContext;
import org.gradle.internal.execution.fingerprint.InputFingerprinter;
import org.gradle.internal.execution.history.BeforeExecutionState;
import org.gradle.internal.execution.history.ExecutionHistoryStore;
import org.gradle.internal.execution.history.InputExecutionState;
import org.gradle.internal.execution.history.OutputExecutionState;
import org.gradle.internal.execution.history.OverlappingOutputDetector;
import org.gradle.internal.execution.history.OverlappingOutputs;
import org.gradle.internal.execution.history.PreviousExecutionState;
import org.gradle.internal.execution.history.impl.DefaultBeforeExecutionState;
import org.gradle.internal.execution.steps.BeforeExecutionContext;
import org.gradle.internal.execution.steps.BuildOperationStep;
import org.gradle.internal.execution.steps.CachingResult;
import org.gradle.internal.execution.steps.PreviousExecutionContext;
import org.gradle.internal.execution.steps.Step;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.hash.ClassLoaderHierarchyHasher;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationType;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.impl.ImplementationSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaptureStateBeforeExecutionStep
extends BuildOperationStep<PreviousExecutionContext, CachingResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CaptureStateBeforeExecutionStep.class);
    private final ClassLoaderHierarchyHasher classLoaderHierarchyHasher;
    private final OutputSnapshotter outputSnapshotter;
    private final OverlappingOutputDetector overlappingOutputDetector;
    private final Step<? super BeforeExecutionContext, ? extends CachingResult> delegate;

    public CaptureStateBeforeExecutionStep(BuildOperationExecutor buildOperationExecutor, ClassLoaderHierarchyHasher classLoaderHierarchyHasher, OutputSnapshotter outputSnapshotter, OverlappingOutputDetector overlappingOutputDetector, Step<? super BeforeExecutionContext, ? extends CachingResult> delegate) {
        super(buildOperationExecutor);
        this.classLoaderHierarchyHasher = classLoaderHierarchyHasher;
        this.outputSnapshotter = outputSnapshotter;
        this.overlappingOutputDetector = overlappingOutputDetector;
        this.delegate = delegate;
    }

    @Override
    public CachingResult execute(UnitOfWork work, final PreviousExecutionContext context) {
        final Optional beforeExecutionState = context.getHistory().flatMap(history -> this.captureExecutionState(work, context));
        return this.delegate.execute(work, new BeforeExecutionContext(){

            @Override
            public Optional<BeforeExecutionState> getBeforeExecutionState() {
                return beforeExecutionState;
            }

            @Override
            public Optional<String> getNonIncrementalReason() {
                return context.getNonIncrementalReason();
            }

            @Override
            public WorkValidationContext getValidationContext() {
                return context.getValidationContext();
            }

            @Override
            public ImmutableSortedMap<String, ValueSnapshot> getInputProperties() {
                return this.getBeforeExecutionState().map(InputExecutionState::getInputProperties).orElseGet(context::getInputProperties);
            }

            @Override
            public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> getInputFileProperties() {
                return this.getBeforeExecutionState().map(BeforeExecutionState::getInputFileProperties).orElseGet(context::getInputFileProperties);
            }

            @Override
            public UnitOfWork.Identity getIdentity() {
                return context.getIdentity();
            }

            @Override
            public File getWorkspace() {
                return context.getWorkspace();
            }

            @Override
            public Optional<ExecutionHistoryStore> getHistory() {
                return context.getHistory();
            }

            @Override
            public Optional<PreviousExecutionState> getPreviousExecutionState() {
                return context.getPreviousExecutionState();
            }
        });
    }

    @Nonnull
    private Optional<BeforeExecutionState> captureExecutionState(UnitOfWork work, PreviousExecutionContext context) {
        return this.operation(operationContext -> {
            ImmutableSortedMap<String, FileSystemSnapshot> unfilteredOutputSnapshots;
            try {
                unfilteredOutputSnapshots = this.outputSnapshotter.snapshotOutputs(work, context.getWorkspace());
            }
            catch (OutputSnapshotter.OutputFileSnapshottingException e) {
                work.handleUnreadableOutputs(e);
                operationContext.setResult((Object)Operation.Result.INSTANCE);
                return Optional.empty();
            }
            try {
                BeforeExecutionState executionState = this.captureExecutionStateWithOutputs(work, context, unfilteredOutputSnapshots);
                operationContext.setResult((Object)Operation.Result.INSTANCE);
                return Optional.of(executionState);
            }
            catch (InputFingerprinter.InputFileFingerprintingException e) {
                work.handleUnreadableInputs(e);
                operationContext.setResult((Object)Operation.Result.INSTANCE);
                return Optional.empty();
            }
        }, BuildOperationDescriptor.displayName((String)("Snapshot inputs and outputs before executing " + work.getDisplayName())).details((Object)Operation.Details.INSTANCE));
    }

    private BeforeExecutionState captureExecutionStateWithOutputs(UnitOfWork work, PreviousExecutionContext context, ImmutableSortedMap<String, FileSystemSnapshot> unfilteredOutputSnapshots) {
        OverlappingOutputs overlappingOutputs;
        Optional<PreviousExecutionState> previousExecutionState = context.getPreviousExecutionState();
        ImplementationsBuilder implementationsBuilder = new ImplementationsBuilder(this.classLoaderHierarchyHasher);
        work.visitImplementations(implementationsBuilder);
        ImplementationSnapshot implementation = implementationsBuilder.getImplementation();
        ImmutableList<ImplementationSnapshot> additionalImplementations = implementationsBuilder.getAdditionalImplementations();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Implementation for {}: {}", (Object)work.getDisplayName(), (Object)implementation);
            LOGGER.debug("Additional implementations for {}: {}", (Object)work.getDisplayName(), additionalImplementations);
        }
        ImmutableSortedMap previousInputProperties = previousExecutionState.map(InputExecutionState::getInputProperties).orElse(ImmutableSortedMap.of());
        ImmutableSortedMap previousInputFileFingerprints = previousExecutionState.map(InputExecutionState::getInputFileProperties).orElse(ImmutableSortedMap.of());
        ImmutableSortedMap previousOutputSnapshots = previousExecutionState.map(OutputExecutionState::getOutputFilesProducedByWork).orElse(ImmutableSortedMap.of());
        switch (work.getOverlappingOutputHandling()) {
            case DETECT_OVERLAPS: {
                overlappingOutputs = this.overlappingOutputDetector.detect((ImmutableSortedMap<String, FileSystemSnapshot>)previousOutputSnapshots, unfilteredOutputSnapshots);
                break;
            }
            case IGNORE_OVERLAPS: {
                overlappingOutputs = null;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        InputFingerprinter.Result newInputs = work.getInputFingerprinter().fingerprintInputProperties((ImmutableSortedMap<String, ValueSnapshot>)previousInputProperties, (ImmutableSortedMap<String, ? extends FileCollectionFingerprint>)previousInputFileFingerprints, context.getInputProperties(), context.getInputFileProperties(), work::visitRegularInputs);
        ImmutableSortedMap<String, ValueSnapshot> inputProperties = CaptureStateBeforeExecutionStep.union(context.getInputProperties(), newInputs.getValueSnapshots());
        ImmutableSortedMap<String, CurrentFileCollectionFingerprint> inputFileFingerprints = CaptureStateBeforeExecutionStep.union(context.getInputFileProperties(), newInputs.getFileFingerprints());
        return new DefaultBeforeExecutionState(implementation, additionalImplementations, inputProperties, inputFileFingerprints, unfilteredOutputSnapshots, overlappingOutputs);
    }

    private static <K extends Comparable<?>, V> ImmutableSortedMap<K, V> union(ImmutableSortedMap<K, V> a, ImmutableSortedMap<K, V> b) {
        if (a.isEmpty()) {
            return b;
        }
        if (b.isEmpty()) {
            return a;
        }
        return ImmutableSortedMap.naturalOrder().putAll(a).putAll(b).build();
    }

    public static interface Operation
    extends BuildOperationType<Details, Result> {

        public static interface Result {
            public static final Result INSTANCE = new Result(){};
        }

        public static interface Details {
            public static final Details INSTANCE = new Details(){};
        }
    }

    private static class ImplementationsBuilder
    implements UnitOfWork.ImplementationVisitor {
        private final ClassLoaderHierarchyHasher classLoaderHierarchyHasher;
        private ImplementationSnapshot implementation;
        private final ImmutableList.Builder<ImplementationSnapshot> additionalImplementations = ImmutableList.builder();

        public ImplementationsBuilder(ClassLoaderHierarchyHasher classLoaderHierarchyHasher) {
            this.classLoaderHierarchyHasher = classLoaderHierarchyHasher;
        }

        @Override
        public void visitImplementation(Class<?> implementation) {
            this.visitImplementation(ImplementationSnapshot.of(implementation, (ClassLoaderHierarchyHasher)this.classLoaderHierarchyHasher));
        }

        @Override
        public void visitImplementation(ImplementationSnapshot implementation) {
            if (this.implementation == null) {
                this.implementation = implementation;
            } else {
                this.additionalImplementations.add((Object)implementation);
            }
        }

        public ImplementationSnapshot getImplementation() {
            if (this.implementation == null) {
                throw new IllegalStateException("No implementation is set");
            }
            return this.implementation;
        }

        public ImmutableList<ImplementationSnapshot> getAdditionalImplementations() {
            return this.additionalImplementations.build();
        }
    }
}

