/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.build;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.build.ExecutionResult;

public class StateTransitionController<T extends State> {
    private final Set<T> achievedStates = new HashSet<T>();
    private T state;
    @Nullable
    private Thread owner;
    @Nullable
    private T currentTarget;
    @Nullable
    private ExecutionResult<?> failure;

    public StateTransitionController(T initialState) {
        this.state = initialState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertInState(T expected) {
        StateTransitionController stateTransitionController = this;
        synchronized (stateTransitionController) {
            if (this.state != expected) {
                throw new IllegalStateException("Should be in state " + expected + ".");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertNotInState(T forbidden) {
        StateTransitionController stateTransitionController = this;
        synchronized (stateTransitionController) {
            if (this.state == forbidden) {
                throw new IllegalStateException("Should not be in state " + forbidden + ".");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S> S notInStateIgnoreOtherThreads(T forbidden, Supplier<S> supplier) {
        StateTransitionController stateTransitionController = this;
        synchronized (stateTransitionController) {
            this.rethrowFailure();
            if (this.currentTarget == forbidden) {
                throw new IllegalStateException("Should not be in state " + forbidden + " but is in state " + this.state + " and transitioning to " + this.currentTarget + ".");
            }
            if (this.state == forbidden) {
                throw new IllegalStateException("Should not be in state " + forbidden + ".");
            }
        }
        try {
            return supplier.get();
        }
        catch (Throwable t) {
            StateTransitionController stateTransitionController2 = this;
            synchronized (stateTransitionController2) {
                if (this.failure == null) {
                    this.failure = ExecutionResult.failed(t);
                }
            }
            throw UncheckedException.throwAsUncheckedException((Throwable)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inState(T expected, Runnable action) {
        Thread previousOwner = this.takeOwnership();
        try {
            this.assertNotFailed();
            if (this.currentTarget != null) {
                throw new IllegalStateException("Expected to be in state " + expected + " but is in state " + this.state + " and transitioning to " + this.currentTarget + ".");
            }
            if (this.state != expected) {
                throw new IllegalStateException("Expected to be in state " + expected + " but is in state " + this.state + ".");
            }
            try {
                action.run();
            }
            catch (Throwable t) {
                this.failure = ExecutionResult.failed(t);
                this.failure.rethrow();
            }
        }
        finally {
            this.releaseOwnership(previousOwner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transition(T fromState, T toState, Runnable action) {
        Thread previousOwner = this.takeOwnership();
        try {
            this.doTransition(fromState, toState, action);
        }
        finally {
            this.releaseOwnership(previousOwner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S> S transition(T fromState, T toState, Supplier<? extends S> action) {
        Thread previousOwner = this.takeOwnership();
        try {
            S s = this.doTransition(fromState, toState, () -> ExecutionResult.succeeded(action.get())).getValueOrRethrow();
            return s;
        }
        finally {
            this.releaseOwnership(previousOwner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutionResult<Void> tryTransition(T fromState, T toState, Supplier<ExecutionResult<Void>> action) {
        Thread previousOwner = this.takeOwnership();
        try {
            ExecutionResult<Void> executionResult = this.doTransition(fromState, toState, action);
            return executionResult;
        }
        finally {
            this.releaseOwnership(previousOwner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maybeTransition(T fromState, T toState, Runnable action) {
        Thread previousOwner = this.takeOwnership();
        try {
            if (this.state == toState && this.currentTarget == null) {
                return;
            }
            this.doTransition(fromState, toState, action);
        }
        finally {
            this.releaseOwnership(previousOwner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transitionIfNotPreviously(T fromState, T toState, Runnable action) {
        Thread previousOwner = this.takeOwnership();
        try {
            if (this.achievedStates.contains(toState)) {
                return;
            }
            this.doTransition(fromState, toState, action);
        }
        finally {
            this.releaseOwnership(previousOwner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutionResult<Void> finish(T toState, Function<ExecutionResult<Void>, ExecutionResult<Void>> action) {
        Thread previousOwner = this.takeOwnership();
        try {
            block10: {
                ExecutionResult<Void> executionResult;
                if (this.state == toState) {
                    ExecutionResult<Void> executionResult2 = ExecutionResult.succeeded();
                    return executionResult2;
                }
                try {
                    if (this.failure != null) break block10;
                    executionResult = action.apply(ExecutionResult.succeeded());
                    this.state = toState;
                    this.achievedStates.add(toState);
                }
                catch (Throwable throwable) {
                    this.state = toState;
                    this.achievedStates.add(toState);
                    throw throwable;
                }
                return executionResult;
            }
            ExecutionResult<Void> executionResult = action.apply(this.failure.asFailure());
            this.state = toState;
            this.achievedStates.add(toState);
            return executionResult;
        }
        finally {
            this.releaseOwnership(previousOwner);
        }
    }

    private void doTransition(T fromState, T toState, Runnable action) {
        this.doTransition(fromState, toState, () -> {
            action.run();
            return ExecutionResult.succeeded();
        }).getValueOrRethrow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <S> ExecutionResult<S> doTransition(T fromState, T toState, Supplier<ExecutionResult<S>> action) {
        this.assertNotFailed();
        if (this.currentTarget != null) {
            if (this.currentTarget == toState) {
                throw new IllegalStateException("Cannot transition to state " + toState + " as already transitioning to this state.");
            }
            throw new IllegalStateException("Cannot transition to state " + toState + " as already transitioning to state " + this.currentTarget + ".");
        }
        if (this.state != fromState) {
            throw new IllegalStateException("Can only transition to state " + toState + " from state " + fromState + " however currently in state " + this.state + ".");
        }
        this.currentTarget = toState;
        try {
            ExecutionResult<Object> result;
            try {
                result = action.get();
            }
            catch (Throwable t) {
                result = ExecutionResult.failed(t);
            }
            if (!result.getFailures().isEmpty()) {
                this.failure = result;
            } else {
                this.state = toState;
                this.achievedStates.add(toState);
            }
            ExecutionResult<Object> executionResult = result;
            return executionResult;
        }
        finally {
            this.currentTarget = null;
        }
    }

    private void assertNotFailed() {
        if (this.failure != null) {
            throw new IllegalStateException("Cannot use this object as a previous transition failed.");
        }
    }

    private void rethrowFailure() {
        if (this.failure != null) {
            this.failure.rethrow();
        }
    }

    @Nullable
    private Thread takeOwnership() {
        Thread currentThread = Thread.currentThread();
        StateTransitionController stateTransitionController = this;
        synchronized (stateTransitionController) {
            if (this.owner == null) {
                this.owner = currentThread;
                return null;
            }
            if (this.owner == currentThread) {
                return currentThread;
            }
            throw new IllegalStateException("Another thread is currently transitioning state from " + this.state + " to " + this.currentTarget + ".");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseOwnership(@Nullable Thread previousOwner) {
        StateTransitionController stateTransitionController = this;
        synchronized (stateTransitionController) {
            this.owner = previousOwner;
        }
    }

    public static interface State {
    }
}

