/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.io.File;
import java.util.Set;
import java.util.function.Function;
import org.gradle.BuildListener;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.initialization.Settings;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.composite.internal.IncludedBuildTaskGraph;
import org.gradle.initialization.RunNestedBuildBuildOperationType;
import org.gradle.initialization.exception.ExceptionAnalyser;
import org.gradle.initialization.layout.BuildLayout;
import org.gradle.internal.InternalBuildAdapter;
import org.gradle.internal.Pair;
import org.gradle.internal.build.AbstractBuildState;
import org.gradle.internal.build.BuildLifecycleController;
import org.gradle.internal.build.BuildLifecycleControllerFactory;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.BuildWorkGraph;
import org.gradle.internal.build.NestedRootBuild;
import org.gradle.internal.build.RootBuildState;
import org.gradle.internal.buildtree.BuildTreeFinishExecutor;
import org.gradle.internal.buildtree.BuildTreeLifecycleController;
import org.gradle.internal.buildtree.BuildTreeLifecycleControllerFactory;
import org.gradle.internal.buildtree.BuildTreeModelControllerServices;
import org.gradle.internal.buildtree.BuildTreeState;
import org.gradle.internal.buildtree.BuildTreeWorkExecutor;
import org.gradle.internal.buildtree.DefaultBuildTreeFinishExecutor;
import org.gradle.internal.buildtree.DefaultBuildTreeWorkExecutor;
import org.gradle.internal.composite.IncludedBuildInternal;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.scopes.BuildScopeServices;
import org.gradle.internal.session.BuildSessionState;
import org.gradle.util.Path;

public class RootOfNestedBuildTree
extends AbstractBuildState
implements NestedRootBuild {
    private final BuildIdentifier buildIdentifier;
    private final Path identityPath;
    private final BuildState owner;
    private final BuildLifecycleController buildLifecycleController;
    private final BuildTreeLifecycleController buildTreeLifecycleController;
    private String buildName;
    private final BuildTreeState buildTree;
    private final BuildScopeServices buildServices;

    public RootOfNestedBuildTree(BuildDefinition buildDefinition, BuildIdentifier buildIdentifier, Path identityPath, BuildState owner, BuildSessionState buildSessionState) {
        this.buildIdentifier = buildIdentifier;
        this.identityPath = identityPath;
        this.owner = owner;
        this.buildName = buildDefinition.getName() == null ? buildIdentifier.getName() : buildDefinition.getName();
        StartParameterInternal startParameter = buildDefinition.getStartParameter();
        BuildTreeModelControllerServices.Supplier modelServices = ((BuildTreeModelControllerServices)buildSessionState.getServices().get(BuildTreeModelControllerServices.class)).servicesForNestedBuildTree(startParameter);
        this.buildTree = new BuildTreeState(buildSessionState.getServices(), modelServices);
        BuildLifecycleControllerFactory buildLifecycleControllerFactory = (BuildLifecycleControllerFactory)this.buildTree.getServices().get(BuildLifecycleControllerFactory.class);
        this.buildServices = new BuildScopeServices(this.buildTree.getServices());
        this.buildLifecycleController = buildLifecycleControllerFactory.newInstance(buildDefinition, (BuildState)this, owner, this.buildServices);
        BuildTreeLifecycleControllerFactory buildTreeLifecycleControllerFactory = (BuildTreeLifecycleControllerFactory)this.buildServices.get(BuildTreeLifecycleControllerFactory.class);
        IncludedBuildTaskGraph controllers = (IncludedBuildTaskGraph)this.buildServices.get(IncludedBuildTaskGraph.class);
        ExceptionAnalyser exceptionAnalyser = (ExceptionAnalyser)this.buildServices.get(ExceptionAnalyser.class);
        BuildStateRegistry buildStateRegistry = (BuildStateRegistry)this.buildServices.get(BuildStateRegistry.class);
        DefaultBuildTreeWorkExecutor buildTreeWorkExecutor = new DefaultBuildTreeWorkExecutor(controllers, this.buildLifecycleController);
        DefaultBuildTreeFinishExecutor buildTreeFinishExecutor = new DefaultBuildTreeFinishExecutor(buildStateRegistry, exceptionAnalyser, this.buildLifecycleController);
        this.buildTreeLifecycleController = buildTreeLifecycleControllerFactory.createController(this.buildLifecycleController, (BuildTreeWorkExecutor)buildTreeWorkExecutor, (BuildTreeFinishExecutor)buildTreeFinishExecutor);
    }

    public void attach() {
        ((BuildStateRegistry)this.buildServices.get(BuildStateRegistry.class)).attachRootBuild((RootBuildState)this);
    }

    protected BuildLifecycleController getBuildController() {
        return this.buildLifecycleController;
    }

    public BuildWorkGraph getWorkGraph() {
        return (BuildWorkGraph)this.buildServices.get(BuildWorkGraph.class);
    }

    protected ProjectStateRegistry getProjectStateRegistry() {
        return (ProjectStateRegistry)this.buildServices.get(ProjectStateRegistry.class);
    }

    public StartParameterInternal getStartParameter() {
        return this.buildLifecycleController.getGradle().getStartParameter();
    }

    public BuildIdentifier getBuildIdentifier() {
        return this.buildIdentifier;
    }

    public Path getIdentityPath() {
        return this.identityPath;
    }

    public boolean isImplicitBuild() {
        return false;
    }

    public Path getCurrentPrefixForProjectsInChildBuilds() {
        return this.owner.getCurrentPrefixForProjectsInChildBuilds().child(this.buildName);
    }

    public Path calculateIdentityPathForProject(Path projectPath) {
        return this.buildLifecycleController.getGradle().getIdentityPath().append(projectPath);
    }

    public File getBuildRootDir() {
        return ((BuildLayout)this.buildLifecycleController.getGradle().getServices().get(BuildLayout.class)).getRootDirectory();
    }

    public IncludedBuildInternal getModel() {
        throw new UnsupportedOperationException();
    }

    public Set<Pair<ModuleVersionIdentifier, ProjectComponentIdentifier>> getAvailableModules() {
        throw new UnsupportedOperationException();
    }

    public ProjectComponentIdentifier idToReferenceProjectFromAnotherBuild(ProjectComponentIdentifier identifier) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T run(final Function<? super BuildTreeLifecycleController, T> action) {
        Object object;
        try {
            final GradleInternal gradle = this.buildLifecycleController.getGradle();
            ServiceRegistry services = gradle.getServices();
            BuildOperationExecutor executor = (BuildOperationExecutor)services.get(BuildOperationExecutor.class);
            object = executor.call(new CallableBuildOperation<T>(){

                public T call(BuildOperationContext context) {
                    gradle.addBuildListener((BuildListener)new InternalBuildAdapter(){

                        public void settingsEvaluated(Settings settings) {
                            RootOfNestedBuildTree.this.buildName = settings.getRootProject().getName();
                        }
                    });
                    Object result = action.apply(RootOfNestedBuildTree.this.buildTreeLifecycleController);
                    context.setResult((Object)new RunNestedBuildBuildOperationType.Result(){});
                    return result;
                }

                public BuildOperationDescriptor.Builder description() {
                    return BuildOperationDescriptor.displayName((String)"Run nested build").details((Object)new RunNestedBuildBuildOperationType.Details(){

                        public String getBuildPath() {
                            return gradle.getIdentityPath().getPath();
                        }
                    });
                }
            });
        }
        catch (Throwable throwable) {
            CompositeStoppable.stoppable((Object[])new Object[]{this.buildLifecycleController, this.buildTree}).stop();
            throw throwable;
        }
        CompositeStoppable.stoppable((Object[])new Object[]{this.buildLifecycleController, this.buildTree}).stop();
        return (T)object;
    }

    public GradleInternal getBuild() {
        return this.buildLifecycleController.getGradle();
    }

    public GradleInternal getMutableModel() {
        return this.buildLifecycleController.getGradle();
    }
}

