/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import com.google.common.collect.ImmutableMap;
import java.util.HashSet;
import java.util.Map;
import org.gradle.internal.fingerprint.DirectorySensitivity;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.FingerprintHashingStrategy;
import org.gradle.internal.fingerprint.hashing.FileSystemLocationSnapshotHasher;
import org.gradle.internal.fingerprint.impl.AbstractFingerprintingStrategy;
import org.gradle.internal.fingerprint.impl.IgnoredPathFileSystemLocationFingerprint;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.MissingFileSnapshot;
import org.gradle.internal.snapshot.RegularFileSnapshot;
import org.gradle.internal.snapshot.SnapshotVisitResult;

public class IgnoredPathFingerprintingStrategy
extends AbstractFingerprintingStrategy {
    public static final IgnoredPathFingerprintingStrategy DEFAULT = new IgnoredPathFingerprintingStrategy();
    public static final String IDENTIFIER = "IGNORED_PATH";
    public static final String IGNORED_PATH = "";
    private final FileSystemLocationSnapshotHasher normalizedContentHasher;

    public IgnoredPathFingerprintingStrategy(FileSystemLocationSnapshotHasher normalizedContentHasher) {
        super(IDENTIFIER, DirectorySensitivity.DEFAULT, normalizedContentHasher);
        this.normalizedContentHasher = normalizedContentHasher;
    }

    private IgnoredPathFingerprintingStrategy() {
        this(FileSystemLocationSnapshotHasher.DEFAULT);
    }

    @Override
    public String normalizePath(FileSystemLocationSnapshot snapshot) {
        return IGNORED_PATH;
    }

    @Override
    public Map<String, FileSystemLocationFingerprint> collectFingerprints(FileSystemSnapshot roots) {
        final ImmutableMap.Builder builder = ImmutableMap.builder();
        final HashSet processedEntries = new HashSet();
        roots.accept(snapshot -> {
            snapshot.accept(new FileSystemLocationSnapshot.FileSystemLocationSnapshotVisitor(){

                @Override
                public void visitRegularFile(RegularFileSnapshot fileSnapshot) {
                    this.visitNonDirectoryEntry(snapshot);
                }

                @Override
                public void visitMissing(MissingFileSnapshot missingSnapshot) {
                    this.visitNonDirectoryEntry(snapshot);
                }

                private void visitNonDirectoryEntry(FileSystemLocationSnapshot snapshot2) {
                    HashCode normalizedContentHash;
                    String absolutePath = snapshot2.getAbsolutePath();
                    if (processedEntries.add(absolutePath) && (normalizedContentHash = IgnoredPathFingerprintingStrategy.this.getNormalizedContentHash(snapshot2, IgnoredPathFingerprintingStrategy.this.normalizedContentHasher)) != null) {
                        builder.put((Object)absolutePath, (Object)IgnoredPathFileSystemLocationFingerprint.create(snapshot2.getType(), normalizedContentHash));
                    }
                }
            });
            return SnapshotVisitResult.CONTINUE;
        });
        return builder.build();
    }

    @Override
    public FingerprintHashingStrategy getHashingStrategy() {
        return FingerprintHashingStrategy.SORT;
    }
}

