/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.descriptors.IrBuiltIns;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.interpreter.CallInterceptor;
import org.jetbrains.kotlin.ir.interpreter.CompoundInstruction;
import org.jetbrains.kotlin.ir.interpreter.DefaultCallInterceptor;
import org.jetbrains.kotlin.ir.interpreter.Instruction;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreter;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import org.jetbrains.kotlin.ir.interpreter.SimpleInstruction;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.builtins.IrBuiltInsMapGeneratedKt;
import org.jetbrains.kotlin.ir.interpreter.exceptions.InterpreterError;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.IntrinsicEvaluator;
import org.jetbrains.kotlin.ir.interpreter.proxy.ProxyKt;
import org.jetbrains.kotlin.ir.interpreter.stack.CallStack;
import org.jetbrains.kotlin.ir.interpreter.stack.Variable;
import org.jetbrains.kotlin.ir.interpreter.state.Common;
import org.jetbrains.kotlin.ir.interpreter.state.Complex;
import org.jetbrains.kotlin.ir.interpreter.state.Primitive;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.interpreter.state.StateWithClosure;
import org.jetbrains.kotlin.ir.interpreter.state.Wrapper;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KFunctionState;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KTypeState;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.ReflectionState;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrEnumEntrySymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J\u001e\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J&\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J>\u0010&\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010'\u001a\u0004\u0018\u00010\u001b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00160)H\u0016J4\u0010*\u001a\u00020\u00162\u0006\u0010+\u001a\u00020,2\u0006\u0010'\u001a\u00020\u001b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00160)H\u0016J\u001e\u0010-\u001a\u00020\u00162\u0006\u0010.\u001a\u00020/2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00160)H\u0016J\u001e\u00100\u001a\u00020\u00162\u0006\u00101\u001a\u0002022\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00160)H\u0016J\u0010\u00103\u001a\u00020\u00162\u0006\u00101\u001a\u000204H\u0016J,\u00105\u001a\u0004\u0018\u0001062\u0006\u0010\u0017\u001a\u00020\u00182\f\u00107\u001a\b\u0012\u0004\u0012\u0002080\u001a2\n\u00109\u001a\u0006\u0012\u0002\b\u00030:H\u0016J\u0016\u0010;\u001a\u00020\u001e*\u0004\u0018\u0001062\u0006\u0010<\u001a\u00020\u001eH\u0002J$\u0010=\u001a\u00020\u0016*\u0004\u0018\u00010>2\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J\u000e\u0010?\u001a\u0004\u0018\u00010@*\u00020\u0018H\u0002J\u000e\u0010A\u001a\u0004\u0018\u00010B*\u00020\u0018H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006C"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/DefaultCallInterceptor;", "Lorg/jetbrains/kotlin/ir/interpreter/CallInterceptor;", "interpreter", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreter;", "(Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreter;)V", "bodyMap", "", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "callStack", "Lorg/jetbrains/kotlin/ir/interpreter/stack/CallStack;", "environment", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "getEnvironment", "()Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "getInterpreter", "()Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreter;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;", "getIrBuiltIns", "()Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;", "calculateBuiltIns", "", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "args", "", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "calculateRangeTo", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "handleIntrinsicMethods", "", "handleInvoke", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "functionState", "Lorg/jetbrains/kotlin/ir/interpreter/state/reflection/KFunctionState;", "interceptCall", "receiver", "defaultAction", "Lkotlin/Function0;", "interceptConstructor", "constructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "interceptEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "interceptGetObjectValue", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrGetObjectValue;", "interceptJavaStaticField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "interceptProxy", "", "valueArguments", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Variable;", "expectedResultClass", "Ljava/lang/Class;", "getType", "defaultType", "invokeMethod", "Ljava/lang/invoke/MethodHandle;", "tryCalculateLazyConst", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "trySubstituteFunctionBody", "Lorg/jetbrains/kotlin/ir/IrElement;", "ir.interpreter"})
public final class DefaultCallInterceptor
implements CallInterceptor {
    @NotNull
    private final IrInterpreter interpreter;
    @NotNull
    private final IrInterpreterEnvironment environment;
    @NotNull
    private final CallStack callStack;
    @NotNull
    private final IrBuiltIns irBuiltIns;
    @NotNull
    private final Map<IdSignature, IrBody> bodyMap;

    public DefaultCallInterceptor(@NotNull IrInterpreter interpreter) {
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        this.interpreter = interpreter;
        this.environment = this.getInterpreter().getEnvironment$ir_interpreter();
        this.callStack = this.getEnvironment().getCallStack();
        this.irBuiltIns = this.getEnvironment().getIrBuiltIns();
        this.bodyMap = this.getInterpreter().getBodyMap$ir_interpreter();
    }

    @Override
    @NotNull
    public IrInterpreter getInterpreter() {
        return this.interpreter;
    }

    @Override
    @NotNull
    public IrInterpreterEnvironment getEnvironment() {
        return this.environment;
    }

    @Override
    @NotNull
    public IrBuiltIns getIrBuiltIns() {
        return this.irBuiltIns;
    }

    @Override
    @Nullable
    public Object interceptProxy(@NotNull IrFunction irFunction2, @NotNull List<Variable> valueArguments, @NotNull Class<?> expectedResultClass) {
        Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
        Intrinsics.checkNotNullParameter(valueArguments, (String)"valueArguments");
        Intrinsics.checkNotNullParameter(expectedResultClass, (String)"expectedResultClass");
        IrCallImpl irCall = IrCallImpl.Companion.fromSymbolOwner$default(IrCallImpl.Companion, -1, -1, irFunction2.getReturnType(), (IrSimpleFunctionSymbol)irFunction2.getSymbol(), 0, 0, null, null, 240, null);
        return ProxyKt.wrap(this.getInterpreter().withNewCallStack$ir_interpreter(irCall, (Function1<? super IrInterpreter, ? extends Object>)((Function1)new Function1<IrInterpreter, Unit>(irCall, valueArguments){
            final /* synthetic */ IrCallImpl $irCall;
            final /* synthetic */ List<Variable> $valueArguments;
            {
                this.$irCall = $irCall;
                this.$valueArguments = $valueArguments;
                super(1);
            }

            public final void invoke(@NotNull IrInterpreter $this$withNewCallStack) {
                Intrinsics.checkNotNullParameter((Object)$this$withNewCallStack, (String)"$this$withNewCallStack");
                $this$withNewCallStack.getEnvironment$ir_interpreter().getCallStack().addInstruction(new SimpleInstruction(this.$irCall));
                Iterable $this$forEach$iv = this.$valueArguments;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Variable it = (Variable)element$iv;
                    boolean bl = false;
                    $this$withNewCallStack.getEnvironment$ir_interpreter().getCallStack().addVariable(it);
                }
            }
        })), (CallInterceptor)this, true, expectedResultClass);
    }

    @Override
    public void interceptCall(@NotNull IrCall call2, @NotNull IrFunction irFunction2, @Nullable State receiver, @NotNull List<? extends State> args, @NotNull Function0<Unit> defaultAction) {
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter(defaultAction, (String)"defaultAction");
        boolean isInlineOnly = IrUtilsKt.hasAnnotation((IrAnnotationContainer)irFunction2, new FqName("kotlin.internal.InlineOnly"));
        if (receiver instanceof Wrapper && !isInlineOnly) {
            this.invokeMethod(((Wrapper)receiver).getMethod(irFunction2), irFunction2, args);
        } else if (Wrapper.Companion.mustBeHandledWithWrapper(irFunction2)) {
            this.invokeMethod(Wrapper.Companion.getStaticMethod(irFunction2), irFunction2, args);
        } else {
            if (this.handleIntrinsicMethods(irFunction2)) {
                return;
            }
            if (receiver instanceof KFunctionState && Intrinsics.areEqual((Object)((IrSimpleFunction)call2.getSymbol().getOwner()).getName().asString(), (Object)"invoke")) {
                this.handleInvoke(call2, (KFunctionState)receiver, args);
            } else if (receiver instanceof ReflectionState) {
                this.invokeMethod(Wrapper.Companion.getReflectionMethod(irFunction2), irFunction2, args);
            } else if (receiver instanceof Primitive) {
                this.calculateBuiltIns(irFunction2, args);
            } else if (irFunction2.getBody() == null) {
                IrElement irElement;
                IrElement irElement2 = this.trySubstituteFunctionBody(irFunction2);
                if (irElement2 == null && (irElement = (IrElement)this.tryCalculateLazyConst(irFunction2)) == null) {
                    this.calculateBuiltIns(irFunction2, args);
                }
            } else {
                defaultAction.invoke();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleInvoke(IrCall call2, KFunctionState functionState, List<? extends State> args) {
        int n;
        Object it;
        Object irConstructorCall;
        IrFunction irFunction2;
        void $this$mapTo$iv$iv;
        State state;
        Object it22;
        boolean bl;
        IrValueParameter irValueParameter;
        State state2;
        IrFunction invokedFunction = functionState.getIrFunction();
        int index2 = 0;
        index2 = 1;
        IrValueParameter irValueParameter2 = invokedFunction.getDispatchReceiverParameter();
        if (irValueParameter2 == null) {
            state2 = null;
        } else {
            irValueParameter = irValueParameter2;
            boolean bl2 = false;
            bl = false;
            it22 = irValueParameter;
            boolean bl3 = false;
            State state3 = functionState.getField(((IrValueParameter)it22).getSymbol());
            if (state3 == null) {
                int n2 = index2;
                index2 = n2 + 1;
                state2 = args.get(n2);
            } else {
                state2 = state3;
            }
        }
        State dispatchReceiver = state2;
        irValueParameter = invokedFunction.getExtensionReceiverParameter();
        if (irValueParameter == null) {
            state = null;
        } else {
            IrValueParameter irValueParameter3 = irValueParameter;
            bl = false;
            boolean it22 = false;
            IrValueParameter it3 = irValueParameter3;
            boolean bl4 = false;
            State state4 = functionState.getField(it3.getSymbol());
            if (state4 == null) {
                int n3 = index2;
                index2 = n3 + 1;
                state = args.get(n3);
            } else {
                state = state4;
            }
        }
        State extensionReceiver = state;
        Iterable $this$map$iv = invokedFunction.getValueParameters();
        boolean $i$f$map = false;
        it22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        Object object = $this$mapTo$iv$iv.iterator();
        while (object.hasNext()) {
            Object item$iv$iv = object.next();
            IrValueParameter irValueParameter4 = (IrValueParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl5 = false;
            int n4 = index2;
            index2 = n4 + 1;
            State state5 = args.get(n4);
            collection.add(state5);
        }
        List valueArguments = (List)destination$iv$iv;
        Object symbol2 = invokedFunction.getSymbol();
        if (symbol2 instanceof IrSimpleFunctionSymbol) {
            IrCallImpl irCall = IrCallImpl.Companion.fromSymbolOwner$default(IrCallImpl.Companion, -1, -1, invokedFunction.getReturnType(), (IrSimpleFunctionSymbol)invokedFunction.getSymbol(), 0, 0, null, null, 240, null);
            State $i$f$mapTo2 = dispatchReceiver;
            IrFunction actualFunction = $i$f$mapTo2 == null ? invokedFunction : ((object = $i$f$mapTo2.getIrFunctionByIrCall(irCall)) == null ? invokedFunction : object);
            this.callStack.newFrame(actualFunction);
            this.callStack.addInstruction(new SimpleInstruction(actualFunction));
            this.callStack.addVariable(new Variable(actualFunction.getSymbol(), new KTypeState(call2.getType(), (IrClass)this.getIrBuiltIns().getAnyClass().getOwner())));
            irFunction2 = actualFunction;
        } else if (symbol2 instanceof IrConstructorSymbol) {
            irConstructorCall = IrConstructorCallImpl.Companion.fromSymbolOwner$default(IrConstructorCallImpl.Companion, invokedFunction.getReturnType(), (IrConstructorSymbol)symbol2, null, 4, null);
            this.callStack.newSubFrame((IrElement)irConstructorCall);
            this.callStack.addInstruction(new SimpleInstruction((IrElement)irConstructorCall));
            IrValueParameter irValueParameter5 = IrUtilsKt.getParentAsClass(invokedFunction).getThisReceiver();
            Intrinsics.checkNotNull((Object)irValueParameter5);
            this.callStack.addVariable(new Variable(irValueParameter5.getSymbol(), new Common(IrUtilsKt.getParentAsClass(invokedFunction))));
            irFunction2 = invokedFunction;
        } else {
            irConstructorCall = "unsupported symbol " + symbol2 + " for invoke";
            boolean actualFunction = false;
            throw (Throwable)new NotImplementedError("An operation is not implemented: " + (String)irConstructorCall);
        }
        IrFunction function2 = irFunction2;
        symbol2 = function2.getDispatchReceiverParameter();
        if (symbol2 != null) {
            irConstructorCall = symbol2;
            boolean actualFunction = false;
            boolean $i$f$mapTo2 = false;
            it = irConstructorCall;
            boolean bl6 = false;
            IrSymbol irSymbol2 = ((IrValueParameter)it).getSymbol();
            State state6 = dispatchReceiver;
            Intrinsics.checkNotNull((Object)state6);
            this.callStack.addVariable(new Variable(irSymbol2, state6));
        }
        symbol2 = function2.getExtensionReceiverParameter();
        if (symbol2 != null) {
            irConstructorCall = symbol2;
            boolean actualFunction = false;
            boolean $i$f$mapTo2 = false;
            it = irConstructorCall;
            n = 0;
            IrSymbol irSymbol3 = ((IrValueParameter)it).getSymbol();
            State state7 = extensionReceiver;
            Intrinsics.checkNotNull((Object)state7);
            this.callStack.addVariable(new Variable(irSymbol3, state7));
        }
        Object $this$forEachIndexed$iv = function2.getValueParameters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        Iterator $i$f$mapTo2 = $this$forEachIndexed$iv.iterator();
        while ($i$f$mapTo2.hasNext()) {
            void param;
            Object item$iv = $i$f$mapTo2.next();
            n = index$iv++;
            boolean bl7 = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrValueParameter bl5 = (IrValueParameter)item$iv;
            int i = n;
            boolean bl8 = false;
            this.callStack.addVariable(new Variable(param.getSymbol(), (State)valueArguments.get(i)));
        }
        this.callStack.loadUpValues(functionState);
        if (extensionReceiver instanceof StateWithClosure) {
            this.callStack.loadUpValues((StateWithClosure)((Object)extensionReceiver));
        }
        if (dispatchReceiver instanceof Complex && (($this$forEachIndexed$iv = IrUtilsKt.getParentClassOrNull(function2)) == null ? false : ((IrClass)$this$forEachIndexed$iv).isInner())) {
            Sequence $this$forEach$iv = SequencesKt.generateSequence((Object)((Complex)dispatchReceiver).getOuterClass(), (Function1)handleInvoke.4.INSTANCE);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Variable)element$iv;
                boolean bl9 = false;
                this.callStack.addVariable((Variable)it);
            }
        }
        if (invokedFunction.getSymbol() instanceof IrConstructorSymbol) {
            return;
        }
        Object[] objectArray = new State[]{dispatchReceiver, extensionReceiver};
        this.interceptCall(call2, function2, dispatchReceiver, CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object[])objectArray), (Iterable)valueArguments), (Function0<Unit>)((Function0)new Function0<Unit>(this, function2){
            final /* synthetic */ DefaultCallInterceptor this$0;
            final /* synthetic */ IrFunction $function;
            {
                this.this$0 = $receiver;
                this.$function = $function;
                super(0);
            }

            public final void invoke() {
                DefaultCallInterceptor.access$getCallStack$p(this.this$0).addInstruction(new CompoundInstruction(this.$function));
            }
        }));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public void interceptConstructor(@NotNull IrFunctionAccessExpression constructorCall, @NotNull State receiver, @NotNull List<? extends State> args, @NotNull Function0<Unit> defaultAction) {
        void $this$interceptConstructor_u24lambda_u2d9;
        IrClass irClass2;
        IrFunction irConstructor2;
        block9: {
            block8: {
                Intrinsics.checkNotNullParameter((Object)constructorCall, (String)"constructorCall");
                Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
                Intrinsics.checkNotNullParameter(args, (String)"args");
                Intrinsics.checkNotNullParameter(defaultAction, (String)"defaultAction");
                irConstructor2 = ((IrFunctionSymbol)constructorCall.getSymbol()).getOwner();
                irClass2 = IrUtilsKt.getParentAsClass(irConstructor2);
                if (Wrapper.Companion.mustBeHandledWithWrapper(irClass2)) break block8;
                FqName fqName2 = IrUtilsKt.getFqNameWhenAvailable(irClass2);
                Intrinsics.checkNotNull((Object)fqName2);
                if (!fqName2.startsWith(Name.identifier("java"))) break block9;
            }
            this.invokeMethod(Wrapper.Companion.getConstructorMethod(irConstructor2), irConstructor2, args);
            if (constructorCall instanceof IrConstructorCall) return;
            ((Common)receiver).setSuperWrapperClass((Wrapper)this.callStack.popState());
            return;
        }
        if (IrTypePredicatesKt.isArray(IrUtilsKt.getDefaultType(irClass2)) || UtilsKt.isPrimitiveArray(IrUtilsKt.getDefaultType(irClass2))) {
            this.callStack.addVariable(new Variable(irConstructor2.getSymbol(), new KTypeState(constructorCall.getType(), (IrClass)this.getIrBuiltIns().getAnyClass().getOwner())));
            boolean bl = this.handleIntrinsicMethods(irConstructor2);
            boolean bl2 = false;
            if (!_Assertions.ENABLED) return;
            if (bl) return;
            boolean $i$a$-assert-DefaultCallInterceptor$interceptConstructor$22 = false;
            String $i$a$-assert-DefaultCallInterceptor$interceptConstructor$22 = Intrinsics.stringPlus((String)"Unsupported intrinsic constructor: ", (Object)RenderIrElementKt.render(irConstructor2));
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-DefaultCallInterceptor$interceptConstructor$22));
        }
        if (!IrTypePredicatesKt.isUnsignedType$default(IrUtilsKt.getDefaultType(irClass2), false, 1, null)) {
            defaultAction.invoke();
            return;
        }
        Iterable $this$single$iv = irClass2.getDeclarations();
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv22 = false;
        for (Object element$iv : $this$single$iv) {
            IrDeclaration it = (IrDeclaration)element$iv;
            boolean bl = false;
            if (!(it instanceof IrProperty)) continue;
            if (found$iv22) {
                throw (Throwable)new IllegalArgumentException("Collection contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv22 = true;
        }
        if (!found$iv22) {
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        IrSymbol propertySymbol = ((IrDeclaration)single$iv).getSymbol();
        State state = receiver;
        boolean bl = false;
        boolean bl3 = false;
        State found$iv22 = state;
        CallStack callStack = this.callStack;
        boolean bl4 = false;
        void var13_20 = $this$interceptConstructor_u24lambda_u2d9;
        Collection collection = var13_20.getFields();
        Variable variable2 = new Variable(propertySymbol, (State)CollectionsKt.single(args));
        boolean bl5 = false;
        collection.add(variable2);
        Unit unit = Unit.INSTANCE;
        callStack.pushState(state);
    }

    @Override
    public void interceptGetObjectValue(@NotNull IrGetObjectValue expression2, @NotNull Function0<Unit> defaultAction) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter(defaultAction, (String)"defaultAction");
        IrClass objectClass = (IrClass)expression2.getSymbol().getOwner();
        if (Wrapper.Companion.mustBeHandledWithWrapper(objectClass)) {
            Wrapper result2 = Wrapper.Companion.getCompanionObject(objectClass);
            Map<IrSymbol, Complex> map = this.getEnvironment().getMapOfObjects();
            IrClassSymbol irClassSymbol = expression2.getSymbol();
            boolean bl = false;
            map.put(irClassSymbol, result2);
            this.callStack.pushState(result2);
        } else {
            defaultAction.invoke();
        }
    }

    @Override
    public void interceptEnumEntry(@NotNull IrEnumEntry enumEntry, @NotNull Function0<Unit> defaultAction) {
        Intrinsics.checkNotNullParameter((Object)enumEntry, (String)"enumEntry");
        Intrinsics.checkNotNullParameter(defaultAction, (String)"defaultAction");
        IrClass enumClass2 = IrUtilsKt.getParentAsClass((IrDeclaration)enumEntry.getSymbol().getOwner());
        if (Wrapper.Companion.mustBeHandledWithWrapper(enumClass2)) {
            State enumEntryName = UtilsKt.toState(enumEntry.getName().asString(), this.getEnvironment().getIrBuiltIns().getStringType());
            Iterable $this$single$iv = enumClass2.getDeclarations();
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                IrDeclaration it = (IrDeclaration)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)AdditionalIrUtilsKt.getNameForIrSerialization(it).asString(), (Object)"valueOf")) continue;
                if (found$iv) {
                    throw (Throwable)new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            IrFunction valueOfFun = single$iv;
            this.invokeMethod(Wrapper.Companion.getEnumEntry(enumClass2), valueOfFun, CollectionsKt.listOf((Object)enumEntryName));
            Map<IrSymbol, Complex> map = this.getEnvironment().getMapOfEnums();
            IrEnumEntrySymbol irEnumEntrySymbol = enumEntry.getSymbol();
            Complex complex = (Complex)this.callStack.popState();
            boolean bl = false;
            map.put(irEnumEntrySymbol, complex);
        } else {
            defaultAction.invoke();
        }
    }

    @Override
    public void interceptJavaStaticField(@NotNull IrGetField expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrField field2 = (IrField)expression2.getSymbol().getOwner();
        boolean bl = Intrinsics.areEqual((Object)field2.getOrigin(), (Object)IrDeclarationOrigin.IR_EXTERNAL_JAVA_DECLARATION_STUB.INSTANCE) && field2.isStatic();
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        IrExpressionBody irExpressionBody = field2.getInitializer();
        boolean bl5 = !((irExpressionBody == null ? null : irExpressionBody.getExpression()) instanceof IrConst);
        bl2 = false;
        bl3 = false;
        if (_Assertions.ENABLED && !bl5) {
            boolean bl6 = false;
            String string3 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string3));
        }
        this.callStack.pushState(UtilsKt.toState(Wrapper.Companion.getStaticGetter(field2).invokeWithArguments(new Object[0]), field2.getType()));
    }

    private final void invokeMethod(MethodHandle $this$invokeMethod, IrFunction irFunction2, List<? extends State> args) {
        MethodHandle methodHandle = $this$invokeMethod;
        if (methodHandle == null) {
            boolean bl = this.handleIntrinsicMethods(irFunction2);
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-DefaultCallInterceptor$invokeMethod$22 = false;
                String $i$a$-assert-DefaultCallInterceptor$invokeMethod$22 = Intrinsics.stringPlus((String)"Unsupported intrinsic function: ", (Object)RenderIrElementKt.render(irFunction2));
                throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-DefaultCallInterceptor$invokeMethod$22));
            }
            return;
        }
        CallInterceptor callInterceptor = this;
        MethodType methodType = $this$invokeMethod.type();
        Intrinsics.checkNotNullExpressionValue((Object)methodType, (String)"this.type()");
        List<Object> argsForMethodInvocation = UtilsKt.getArgsForMethodInvocation(irFunction2, callInterceptor, methodType, args);
        IrInterpreterEnvironment environment$iv = this.getEnvironment();
        boolean $i$f$withExceptionHandler = false;
        try {
            boolean bl = false;
            Object result2 = $this$invokeMethod.invokeWithArguments(argsForMethodInvocation);
            this.callStack.pushState(UtilsKt.toState(result2, this.getType(result2, irFunction2.getReturnType())));
        }
        catch (Throwable e$iv) {
            UtilsKt.handleUserException(e$iv, environment$iv);
        }
    }

    private final boolean handleIntrinsicMethods(IrFunction irFunction2) {
        List<Instruction> list2 = IntrinsicEvaluator.INSTANCE.unwindInstructions(irFunction2, this.getEnvironment());
        if (list2 == null) {
            return false;
        }
        List<Instruction> instructions = list2;
        Iterable $this$forEach$iv = instructions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Instruction it = (Instruction)element$iv;
            boolean bl = false;
            this.callStack.addInstruction(it);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final void calculateBuiltIns(IrFunction irFunction2, List<? extends State> args) {
        Collection<IrType> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object = irFunction2 instanceof IrSimpleFunction ? (IrSimpleFunction)irFunction2 : null;
        Object property2 = object == null ? null : ((IrSimpleFunction)object).getCorrespondingPropertySymbol();
        String string2 = property2 == null ? irFunction2.getName().asString() : ((IrProperty)property2.getOwner()).getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"when (val property = (ir\u2026name.asString()\n        }");
        String methodName = string2;
        object = irFunction2.getDispatchReceiverParameter();
        Object object2 = property2 = object == null ? null : ((IrValueDeclaration)object).getType();
        Object receiverType = property2 == null ? ((object = irFunction2.getExtensionReceiverParameter()) == null ? null : ((IrValueDeclaration)object).getType()) : property2;
        object = irFunction2.getValueParameters();
        Collection collection2 = CollectionsKt.listOfNotNull((Object)receiverType);
        boolean $i$f$map = false;
        void var8_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            IrType irType = it.getType();
            collection.add(irType);
        }
        collection = (List)destination$iv$iv;
        List argsType = CollectionsKt.plus((Collection)collection2, (Iterable)collection);
        List argsValues = ProxyKt.wrap$default(args, (CallInterceptor)this, irFunction2, null, 4, null);
        IrInterpreterEnvironment environment$iv = this.getEnvironment();
        boolean $i$f$withExceptionHandler = false;
        try {
            Object object3;
            boolean bl = false;
            int n = argsType.size();
            switch (n) {
                case 1: {
                    object3 = IrBuiltInsMapGeneratedKt.interpretUnaryFunction(methodName, UtilsKt.getOnlyName((IrType)argsType.get(0)), argsValues.get(0));
                    break;
                }
                case 2: {
                    String string3 = methodName;
                    if (Intrinsics.areEqual((Object)string3, (Object)"rangeTo")) {
                        this.calculateRangeTo(irFunction2.getReturnType(), args);
                        return;
                    }
                    object3 = IrBuiltInsMapGeneratedKt.interpretBinaryFunction(methodName, UtilsKt.getOnlyName((IrType)argsType.get(0)), UtilsKt.getOnlyName((IrType)argsType.get(1)), argsValues.get(0), argsValues.get(1));
                    break;
                }
                case 3: {
                    object3 = IrBuiltInsMapGeneratedKt.interpretTernaryFunction(methodName, UtilsKt.getOnlyName((IrType)argsType.get(0)), UtilsKt.getOnlyName((IrType)argsType.get(1)), UtilsKt.getOnlyName((IrType)argsType.get(2)), argsValues.get(0), argsValues.get(1), argsValues.get(2));
                    break;
                }
                default: {
                    throw new InterpreterError(Intrinsics.stringPlus((String)"Unsupported number of arguments for invocation as builtin function: ", (Object)methodName));
                }
            }
            Object result2 = object3;
            this.callStack.pushState(UtilsKt.toState(result2, this.getType(result2, irFunction2.getReturnType())));
        }
        catch (Throwable e$iv) {
            UtilsKt.handleUserException(e$iv, environment$iv);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void calculateRangeTo(IrType type2, List<? extends State> args) {
        void $this$mapTo$iv$iv;
        Object object;
        Collection collection;
        void $this$mapTo$iv$iv2;
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(type2);
        Intrinsics.checkNotNull((Object)irClassSymbol);
        IrConstructor constructor2 = (IrConstructor)SequencesKt.first(IrUtilsKt.getConstructors((IrClass)irClassSymbol.getOwner()));
        IrConstructorCallImpl constructorCall = IrConstructorCallImpl.Companion.fromSymbolOwner$default(IrConstructorCallImpl.Companion, constructor2.getReturnType(), constructor2.getSymbol(), null, 4, null);
        Iterable $this$map$iv = constructor2.getValueParameters();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = it.getSymbol();
            collection.add(object);
        }
        List constructorValueParameters = (List)destination$iv$iv;
        Iterable $this$map$iv2 = args;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            State bl = (State)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            object = (Primitive)it;
            collection.add(object);
        }
        List primitiveValueParameters = (List)destination$iv$iv2;
        Iterable $this$forEachIndexed$iv = primitiveValueParameters;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void primitive;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Primitive it = (Primitive)item$iv;
            int index2 = n;
            boolean bl3 = false;
            constructorCall.putValueArgument(index2, UtilsKt.toIrConst$default(primitive.getValue(), ((IrValueParameter)((IrValueParameterSymbol)constructorValueParameters.get(index2)).getOwner()).getType(), 0, 0, 6, null));
        }
        this.callStack.addInstruction(new CompoundInstruction(constructorCall));
    }

    private final IrType getType(Object $this$getType, IrType defaultType) {
        Object object = $this$getType;
        return object instanceof Boolean ? this.getIrBuiltIns().getBooleanType() : (object instanceof Character ? this.getIrBuiltIns().getCharType() : (object instanceof Byte ? this.getIrBuiltIns().getByteType() : (object instanceof Short ? this.getIrBuiltIns().getShortType() : (object instanceof Integer ? this.getIrBuiltIns().getIntType() : (object instanceof Long ? this.getIrBuiltIns().getLongType() : (object instanceof String ? this.getIrBuiltIns().getStringType() : (object instanceof Float ? this.getIrBuiltIns().getFloatType() : (object instanceof Double ? this.getIrBuiltIns().getDoubleType() : (object == null ? this.getIrBuiltIns().getNothingNType() : defaultType)))))))));
    }

    private final IrElement trySubstituteFunctionBody(IrFunction $this$trySubstituteFunctionBody) {
        Object object = $this$trySubstituteFunctionBody.getSymbol().getSignature();
        if (object == null) {
            return null;
        }
        Object signature2 = object;
        if ((object = this.bodyMap.get(signature2)) == null) {
            return null;
        }
        $this$trySubstituteFunctionBody.setBody((IrBody)object);
        this.callStack.addInstruction(new CompoundInstruction($this$trySubstituteFunctionBody));
        return $this$trySubstituteFunctionBody.getBody();
    }

    private final IrExpression tryCalculateLazyConst(IrFunction $this$tryCalculateLazyConst) {
        Object object;
        IrExpressionBody irExpressionBody;
        IrField irField;
        Object object2;
        if (!($this$tryCalculateLazyConst instanceof IrSimpleFunction)) {
            return null;
        }
        Object object3 = ((IrSimpleFunction)$this$tryCalculateLazyConst).getCorrespondingPropertySymbol();
        IrExpression expression2 = object3 == null ? null : ((object2 = (IrProperty)object3.getOwner()) == null ? null : ((irField = ((IrProperty)object2).getBackingField()) == null ? null : ((irExpressionBody = irField.getInitializer()) == null ? null : irExpressionBody.getExpression())));
        object3 = expression2;
        if (object3 == null) {
            object = null;
        } else {
            object2 = object3;
            boolean bl = false;
            boolean bl2 = false;
            Object $this$tryCalculateLazyConst_u24lambda_u2d19 = object2;
            boolean bl3 = false;
            this.callStack.addInstruction(new CompoundInstruction((IrElement)$this$tryCalculateLazyConst_u24lambda_u2d19));
            object = object2;
        }
        return object;
    }

    public static final /* synthetic */ CallStack access$getCallStack$p(DefaultCallInterceptor $this) {
        return $this.callStack;
    }
}

