/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.ir2wasm;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.DeclarationGenerator;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmCompiledModuleFragment;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmModuleCodegenContextImpl;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleFragmentGenerator;", "", "backendContext", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "wasmModuleFragment", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmCompiledModuleFragment;", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmCompiledModuleFragment;)V", "declarationGenerator", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/DeclarationGenerator;", "generateDeclaration", "", "irDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "generateModule", "irModuleFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "generatePackageFragment", "irPackageFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrPackageFragment;", "backend.wasm"})
public final class WasmModuleFragmentGenerator {
    @NotNull
    private final DeclarationGenerator declarationGenerator;

    public WasmModuleFragmentGenerator(@NotNull WasmBackendContext backendContext, @NotNull WasmCompiledModuleFragment wasmModuleFragment) {
        Intrinsics.checkNotNullParameter((Object)backendContext, (String)"backendContext");
        Intrinsics.checkNotNullParameter((Object)wasmModuleFragment, (String)"wasmModuleFragment");
        this.declarationGenerator = new DeclarationGenerator(new WasmModuleCodegenContextImpl(backendContext, wasmModuleFragment));
    }

    public final void generateModule(@NotNull IrModuleFragment irModuleFragment) {
        Intrinsics.checkNotNullParameter((Object)irModuleFragment, (String)"irModuleFragment");
        for (IrFile irFile : irModuleFragment.getFiles()) {
            this.generatePackageFragment(irFile);
        }
    }

    public final void generatePackageFragment(@NotNull IrPackageFragment irPackageFragment) {
        Intrinsics.checkNotNullParameter((Object)irPackageFragment, (String)"irPackageFragment");
        for (IrDeclaration irDeclaration2 : irPackageFragment.getDeclarations()) {
            this.generateDeclaration(irDeclaration2);
        }
    }

    public final void generateDeclaration(@NotNull IrDeclaration irDeclaration2) {
        Intrinsics.checkNotNullParameter((Object)irDeclaration2, (String)"irDeclaration");
        IrElementVisitorVoidKt.acceptVoid(irDeclaration2, this.declarationGenerator);
    }
}

