/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect;

import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public class MethodSet
implements Iterable<Method> {
    private final Map<MethodKey, Method> methods = Maps.newLinkedHashMap();

    public void add(Method method) {
        this.methods.putIfAbsent(new MethodKey(method), method);
    }

    @Override
    public Iterator<Method> iterator() {
        return this.getValues().iterator();
    }

    public Collection<Method> getValues() {
        return Collections.unmodifiableCollection(this.methods.values());
    }

    public boolean isEmpty() {
        return this.methods.isEmpty();
    }

    static class MethodKey {
        private final Method method;
        private final Class<?>[] parameterTypes;

        private MethodKey(Method method) {
            this.method = method;
            this.parameterTypes = method.getParameterTypes();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            MethodKey that = (MethodKey)obj;
            return Objects.equals(this.method.getName(), that.method.getName()) && Objects.equals(this.method.getReturnType(), that.method.getReturnType()) && Arrays.equals(this.parameterTypes, that.parameterTypes);
        }

        public int hashCode() {
            return Objects.hash(this.method.getName(), this.parameterTypes.length);
        }
    }
}

