/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.antlr.internal;

import java.io.File;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.antlr.internal.AntlrExecuter;
import org.gradle.api.plugins.antlr.internal.AntlrResult;
import org.gradle.api.plugins.antlr.internal.AntlrSpec;
import org.gradle.api.plugins.antlr.internal.AntlrWorker;
import org.gradle.process.internal.JavaExecHandleBuilder;
import org.gradle.process.internal.worker.SingleRequestWorkerProcessBuilder;
import org.gradle.process.internal.worker.WorkerProcessFactory;

public class AntlrWorkerManager {
    public AntlrResult runWorker(File workingDir, WorkerProcessFactory workerFactory, FileCollection antlrClasspath, AntlrSpec spec) {
        AntlrWorker antlrWorker = this.createWorkerProcess(workingDir, workerFactory, antlrClasspath, spec);
        return antlrWorker.runAntlr(spec);
    }

    private AntlrWorker createWorkerProcess(File workingDir, WorkerProcessFactory workerFactory, FileCollection antlrClasspath, AntlrSpec spec) {
        SingleRequestWorkerProcessBuilder builder = workerFactory.singleRequestWorker(AntlrWorker.class, AntlrExecuter.class);
        builder.setBaseName("Gradle ANTLR Worker");
        if (antlrClasspath != null) {
            builder.applicationClasspath((Iterable)antlrClasspath);
        }
        builder.sharedPackages(new String[]{"antlr", "org.antlr"});
        JavaExecHandleBuilder javaCommand = builder.getJavaCommand();
        javaCommand.setWorkingDir(workingDir);
        javaCommand.setMaxHeapSize(spec.getMaxHeapSize());
        javaCommand.systemProperty("ANTLR_DO_NOT_EXIT", (Object)"true");
        javaCommand.redirectErrorStream();
        return (AntlrWorker)builder.build();
    }
}

