//**************************************************************************************************
//                                          TypeDefs.cpp                                           *
//                                         --------------                                          *
// Started     : 2009-05-07                                                                        *
// Last Update : 2020-10-20                                                                        *
// Copyright   : (C) 2004-2020 MSWaters                                                            *
//**************************************************************************************************

//**************************************************************************************************
//                                                                                                 *
//      This program is free software; you can redistribute it and/or modify it under the          *
//      terms of the GNU General Public License as published by the Free Software Foundation;      *
//      either version 3 of the License, or (at your option) any later version.                    *
//                                                                                                 *
//**************************************************************************************************

#include "TypeDefs.hpp"

//**************************************************************************************************
// The following completes the definition of new array types. It expands into some C++ code and so
// should only be compiled once (ie. don't put this into a header file rather put it in a source
// file or there will be linker errors).

#include <wx/arrimpl.cpp>

WX_DEFINE_OBJARRAY( ArrayFileName )

//**************************************************************************************************
// Enumerated type to string conversion functions.

wxString & rosEnumEngToStr( eTypeSimEng eSimEng )
{
  static  wxString  osSimEng;

  switch( eSimEng )
  {
    case eSIMR_NGSPICE : osSimEng = "NG-SPICE"; break;
    case eSIMR_GNUCAP  : osSimEng = "GNU-CAP";  break;
    default            : osSimEng = "None";
  }

  return( osSimEng );
}

//--------------------------------------------------------------------------------------------------

wxString & rosEnumEdaToStr( eTypeEDA eEDA )
{
  static  wxString  osEDA;

  switch( eEDA )
  {
    case eEDA_LEPTON  : osEDA = "Lepton-EDA"; break;
    case eEDA_GEDAGAF : osEDA = "gEDA-gaf";   break;
    default           : osEDA = "None";
  }

  return( osEDA );
}

//--------------------------------------------------------------------------------------------------

wxString & rosEnumVwrToStr( eTypeDatVwr eDataVwr )
{
  static  wxString  osDataVwr;

  switch( eDataVwr )
  {
    case eDVWR_GAW     : osDataVwr = "Gaw";   break;
    case eDVWR_GWAVE   : osDataVwr = "Gwave"; break;
    case eDVWR_KST     : osDataVwr = "Kst";   break;
    default            : osDataVwr = "None";
  }

  return( osDataVwr );
}

//--------------------------------------------------------------------------------------------------

wxString & rosEnumCmdToStr( eTypeCmd eCmd )
{
  static  wxString  osCmd;

  switch( eCmd )
  {
    case eCMD_OP : osCmd = "OP"; break;
    case eCMD_DC : osCmd = "DC"; break;
    case eCMD_AC : osCmd = "AC"; break;
    case eCMD_TR : osCmd = "TR"; break;
//  case eCMD_FO : osCmd = "FO"; break;
//  case eCMD_DI : osCmd = "DI"; break;
//  case eCMD_NO : osCmd = "NO"; break;
//  case eCMD_PZ : osCmd = "PZ"; break;
//  case eCMD_SE : osCmd = "SE"; break;
//  case eCMD_TF : osCmd = "TF"; break;
    default      : osCmd = "None";
  }

  return( osCmd );
}

//--------------------------------------------------------------------------------------------------

wxString & rosEnumPhaToStr( eTypeUnits ePhase )
{
  static  wxString  osPhase;

  switch( ePhase )
  {
    case eUNITS_PHAD : osPhase = "Degrees"; break;
    case eUNITS_PHAR : osPhase = "Radians"; break;
    default          : osPhase = "None";
  }

  return( osPhase );
}

//**************************************************************************************************
// String to enumerated type conversion functions.

eTypeSimEng  eStrToEnumEng( const wxString & rosSimEng )
{
  eTypeSimEng  eSimEng;
  wxString     os1;

  os1 = rosSimEng.Upper( );

  if(      os1 == "NG-SPICE" ) eSimEng = eSIMR_NGSPICE;
  else if( os1 == "NGSPICE"  ) eSimEng = eSIMR_NGSPICE;
  else if( os1 == "GNU-CAP"  ) eSimEng = eSIMR_GNUCAP;
  else if( os1 == "GNUCAP"   ) eSimEng = eSIMR_GNUCAP;
  else                         eSimEng = eSIMR_NONE;

  return( eSimEng );
}

//--------------------------------------------------------------------------------------------------

eTypeEDA  eStrToEnumEda( const wxString & rosEDA )
{
  eTypeEDA  eEDA;
  wxString  os1;

  os1 = rosEDA.Upper( );

  if(      os1 == "LEPTON-EDA" ) eEDA = eEDA_LEPTON;
  else if( os1 == "GEDA-GAF"   ) eEDA = eEDA_GEDAGAF;
  else                           eEDA = eEDA_NONE;

  return( eEDA );
}

//--------------------------------------------------------------------------------------------------

eTypeDatVwr  eStrToEnumVwr( const wxString & rosDataVwr )
{
  eTypeDatVwr  eDataVwr;
  wxString     os1;

  os1 = rosDataVwr.Upper( );

  if(      os1 == "GAW"   ) eDataVwr = eDVWR_GAW;
  else if( os1 == "GWAVE" ) eDataVwr = eDVWR_GWAVE;
  else if( os1 == "KST"   ) eDataVwr = eDVWR_KST;
  else                      eDataVwr = eDVWR_NONE;

  return( eDataVwr );
}

//--------------------------------------------------------------------------------------------------

eTypeCmd  eStrToEnumCmd( const wxString & rosCmd )
{
  eTypeCmd  eCmd;
  wxString  os1;

  os1 = rosCmd.Upper( );

  if(      os1 == "OP" ) eCmd = eCMD_OP;
  else if( os1 == "DC" ) eCmd = eCMD_DC;
  else if( os1 == "AC" ) eCmd = eCMD_AC;
  else if( os1 == "TR" ) eCmd = eCMD_TR;
//else if( os1 == "FO" ) eCmd = eCMD_FO;
//else if( os1 == "DI" ) eCmd = eCMD_DI;
//else if( os1 == "NO" ) eCmd = eCMD_NO;
//else if( os1 == "PZ" ) eCmd = eCMD_PZ;
//else if( os1 == "SE" ) eCmd = eCMD_SE;
//else if( os1 == "TF" ) eCmd = eCMD_TF;
  else                   eCmd = eCMD_NONE;

  return( eCmd );
}

//--------------------------------------------------------------------------------------------------

eTypeUnits  eStrToEnumPha( const wxString & rosPhase )
{
  eTypeUnits  ePhase;
  wxString    os1;

  os1 = rosPhase.Upper( );

  if(      os1 == "DEGREES" ) ePhase = eUNITS_PHAD;
  else if( os1 == "RADIANS" ) ePhase = eUNITS_PHAR;
  else                        ePhase = eUNITS_NONE;

  return( ePhase );
}

//**************************************************************************************************
