/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal.impl.jansi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fusesource.jansi.AnsiConsole;
import org.fusesource.jansi.internal.Kernel32;
import org.jline.terminal.Attributes;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.impl.PosixPtyTerminal;
import org.jline.terminal.impl.PosixSysTerminal;
import org.jline.terminal.impl.jansi.JansiNativePty;
import org.jline.terminal.impl.jansi.freebsd.FreeBsdNativePty;
import org.jline.terminal.impl.jansi.linux.LinuxNativePty;
import org.jline.terminal.impl.jansi.osx.OsXNativePty;
import org.jline.terminal.impl.jansi.win.JansiWinSysTerminal;
import org.jline.terminal.spi.Pty;
import org.jline.terminal.spi.SystemStream;
import org.jline.terminal.spi.TerminalProvider;
import org.jline.utils.OSUtils;

public class JansiTerminalProvider
implements TerminalProvider {
    static final int JANSI_MAJOR_VERSION;
    static final int JANSI_MINOR_VERSION;

    public static int getJansiMajorVersion() {
        return JANSI_MAJOR_VERSION;
    }

    public static int getJansiMinorVersion() {
        return JANSI_MINOR_VERSION;
    }

    public static boolean isAtLeast(int major, int minor) {
        return JANSI_MAJOR_VERSION > major || JANSI_MAJOR_VERSION == major && JANSI_MINOR_VERSION >= minor;
    }

    public static void verifyAtLeast(int major, int minor) {
        if (!JansiTerminalProvider.isAtLeast(major, minor)) {
            throw new UnsupportedOperationException("An old version of Jansi is loaded from " + Kernel32.class.getClassLoader().getResource(Kernel32.class.getName().replace('.', '/') + ".class"));
        }
    }

    public JansiTerminalProvider() {
        JansiTerminalProvider.verifyAtLeast(1, 17);
        this.checkIsSystemStream(SystemStream.Output);
    }

    @Override
    public String name() {
        return "jansi";
    }

    public Pty current(SystemStream systemStream) throws IOException {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Linux")) {
            return LinuxNativePty.current(this, systemStream);
        }
        if (osName.startsWith("Mac") || osName.startsWith("Darwin")) {
            return OsXNativePty.current(this, systemStream);
        }
        if (osName.startsWith("Solaris") || osName.startsWith("SunOS")) {
            throw new UnsupportedOperationException("Unsupported platform " + osName);
        }
        if (osName.startsWith("FreeBSD")) {
            return FreeBsdNativePty.current(this, systemStream);
        }
        throw new UnsupportedOperationException("Unsupported platform " + osName);
    }

    public Pty open(Attributes attributes, Size size2) throws IOException {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Linux")) {
            return LinuxNativePty.open(this, attributes, size2);
        }
        if (osName.startsWith("Mac") || osName.startsWith("Darwin")) {
            return OsXNativePty.open(this, attributes, size2);
        }
        if (osName.startsWith("Solaris") || osName.startsWith("SunOS")) {
            throw new UnsupportedOperationException("Unsupported platform " + osName);
        }
        if (osName.startsWith("FreeBSD")) {
            return FreeBsdNativePty.open(this, attributes, size2);
        }
        throw new UnsupportedOperationException("Unsupported platform " + osName);
    }

    @Override
    public Terminal sysTerminal(String name, String type, boolean ansiPassThrough, Charset encoding, boolean nativeSignals, Terminal.SignalHandler signalHandler, boolean paused, SystemStream systemStream) throws IOException {
        if (OSUtils.IS_WINDOWS) {
            return this.winSysTerminal(name, type, ansiPassThrough, encoding, nativeSignals, signalHandler, paused, systemStream);
        }
        return this.posixSysTerminal(name, type, ansiPassThrough, encoding, nativeSignals, signalHandler, paused, systemStream);
    }

    public Terminal winSysTerminal(String name, String type, boolean ansiPassThrough, Charset encoding, boolean nativeSignals, Terminal.SignalHandler signalHandler, boolean paused, SystemStream systemStream) throws IOException {
        JansiWinSysTerminal terminal2 = JansiWinSysTerminal.createTerminal(this, systemStream, name, type, ansiPassThrough, encoding, nativeSignals, signalHandler, paused);
        terminal2.disableScrolling();
        return terminal2;
    }

    public Terminal posixSysTerminal(String name, String type, boolean ansiPassThrough, Charset encoding, boolean nativeSignals, Terminal.SignalHandler signalHandler, boolean paused, SystemStream systemStream) throws IOException {
        Pty pty = this.current(systemStream);
        return new PosixSysTerminal(name, type, pty, encoding, nativeSignals, signalHandler);
    }

    @Override
    public Terminal newTerminal(String name, String type, InputStream in, OutputStream out, Charset encoding, Terminal.SignalHandler signalHandler, boolean paused, Attributes attributes, Size size2) throws IOException {
        Pty pty = this.open(attributes, size2);
        return new PosixPtyTerminal(name, type, pty, in, out, encoding, signalHandler, paused);
    }

    @Override
    public boolean isSystemStream(SystemStream stream2) {
        try {
            return this.checkIsSystemStream(stream2);
        }
        catch (Throwable t) {
            return false;
        }
    }

    private boolean checkIsSystemStream(SystemStream stream2) {
        if (OSUtils.IS_WINDOWS) {
            return JansiWinSysTerminal.isWindowsSystemStream(stream2);
        }
        return JansiNativePty.isPosixSystemStream(stream2);
    }

    @Override
    public String systemStreamName(SystemStream stream2) {
        return JansiNativePty.posixSystemStreamName(stream2);
    }

    @Override
    public int systemStreamWidth(SystemStream stream2) {
        return JansiNativePty.systemStreamWidth(stream2);
    }

    public String toString() {
        return "TerminalProvider[" + this.name() + "]";
    }

    static {
        int major = 0;
        int minor = 0;
        try {
            Matcher m;
            String v = null;
            try (InputStream is2 = AnsiConsole.class.getResourceAsStream("jansi.properties");){
                if (is2 != null) {
                    Properties props = new Properties();
                    props.load(is2);
                    v = props.getProperty("version");
                }
            }
            catch (IOException is2) {
                // empty catch block
            }
            if (v == null) {
                v = AnsiConsole.class.getPackage().getImplementationVersion();
            }
            if (v != null && (m = Pattern.compile("([0-9]+)\\.([0-9]+)([\\.-]\\S+)?").matcher(v)).matches()) {
                major = Integer.parseInt(m.group(1));
                minor = Integer.parseInt(m.group(2));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        JANSI_MAJOR_VERSION = major;
        JANSI_MINOR_VERSION = minor;
    }
}

