/*
 * Decompiled with CFR 0.152.
 */
package mill.main.client;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import mill.main.client.BuildInfo;
import mill.main.client.InputPumper;
import mill.main.client.ProxyStream;
import mill.main.client.ServerCouldNotBeStarted;
import mill.main.client.Util;
import mill.main.client.lock.Locks;
import mill.main.client.lock.TryLocked;

public abstract class ServerLauncher {
    final int serverProcessesLimit = 5;
    final int serverInitWaitMillis = 10000;
    InputStream stdin;
    PrintStream stdout;
    PrintStream stderr;
    Map<String, String> env;
    String[] args;
    Locks[] memoryLocks;
    int forceFailureForTestingMillisDelay;

    public abstract void initServer(Path var1, boolean var2, Locks var3) throws Exception;

    public abstract void preRun(Path var1) throws Exception;

    public ServerLauncher(InputStream inputStream, PrintStream printStream, PrintStream printStream2, Map<String, String> map, String[] stringArray, Locks[] locksArray, int n) {
        this.stdin = inputStream;
        this.stdout = printStream;
        this.stderr = printStream2;
        this.env = map;
        this.args = stringArray;
        this.memoryLocks = locksArray;
        this.forceFailureForTestingMillisDelay = n;
    }

    public Result acquireLocksAndRun(Path path) throws Exception {
        boolean bl;
        boolean bl2 = bl = System.getProperty("jna.nosys") == null;
        if (bl) {
            System.setProperty("jna.nosys", "true");
        }
        int n = 0;
        while (n < 5) {
            Path path2 = path.getParent().resolve(path.getFileName() + "-" + ++n);
            Files.createDirectories(path2, new FileAttribute[0]);
            Locks locks = this.memoryLocks != null ? this.memoryLocks[n - 1] : Locks.files(path2.toString());
            try {
                TryLocked tryLocked = locks.clientLock.tryLock();
                try {
                    if (!tryLocked.isLocked()) continue;
                    Result result2 = new Result();
                    this.preRun(path2);
                    result2.exitCode = this.run(path2, bl, locks);
                    result2.serverDir = path2;
                    Result result3 = result2;
                    return result3;
                }
                finally {
                    if (tryLocked == null) continue;
                    tryLocked.close();
                }
            }
            finally {
                if (locks == null) continue;
                locks.close();
            }
        }
        throw new ServerCouldNotBeStarted("Reached max server processes limit: 5");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int run(Path path, boolean bl, Locks locks) throws Exception {
        try (OutputStream outputStream = Files.newOutputStream(path.resolve("runArgs"), new OpenOption[0]);){
            outputStream.write(Util.hasConsole() ? 1 : 0);
            Util.writeString(outputStream, BuildInfo.millVersion);
            Util.writeArgs(this.args, outputStream);
            Util.writeMap(this.env, outputStream);
        }
        if (locks.processLock.probe()) {
            this.initServer(path, bl, locks);
        }
        while (locks.processLock.probe()) {
            Thread.sleep(1L);
        }
        long l = System.currentTimeMillis();
        Socket socket = null;
        Throwable throwable = null;
        while (socket == null && System.currentTimeMillis() - l < 10000L) {
            try {
                int n = Integer.parseInt(Files.readString(path.resolve("socketPort")));
                socket = new Socket("127.0.0.1", n);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                Thread.sleep(1L);
            }
        }
        if (socket == null) {
            throw new Exception("Failed to connect to server", throwable);
        }
        InputStream inputStream = socket.getInputStream();
        OutputStream outputStream = socket.getOutputStream();
        ProxyStream.Pumper pumper = new ProxyStream.Pumper(inputStream, this.stdout, this.stderr);
        InputPumper inputPumper = new InputPumper(() -> this.stdin, () -> outputStream, true);
        Thread thread = new Thread((Runnable)pumper, "outPump");
        thread.setDaemon(true);
        Thread thread2 = new Thread((Runnable)inputPumper, "inPump");
        thread2.setDaemon(true);
        thread.start();
        thread2.start();
        if (this.forceFailureForTestingMillisDelay > 0) {
            Thread.sleep(this.forceFailureForTestingMillisDelay);
            throw new Exception("Force failure for testing: " + path);
        }
        thread.join();
        try {
            Path path2 = path.resolve("exitCode");
            if (Files.exists(path2, new LinkOption[0])) {
                int n = Integer.parseInt(Files.readAllLines(path2).get(0));
                return n;
            }
            System.err.println("mill-server/ exitCode file not found");
            int n = 1;
            return n;
        }
        finally {
            socket.close();
        }
    }

    public static class Result {
        public int exitCode;
        public Path serverDir;
    }
}

