/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.attribute;

import guru.nidi.graphviz.attribute.Attributes;
import guru.nidi.graphviz.attribute.ForGraph;
import guru.nidi.graphviz.attribute.SingleAttributes;
import java.util.Locale;

public final class GraphAttr {
    private static final String SIZE = "size";
    public static final Attributes<ForGraph> CENTER = new SingleAttributes<Boolean, ForGraph>("center", true);
    public static final Attributes<ForGraph> COMPOUND = new SingleAttributes<Boolean, ForGraph>("compound", true);
    public static final Attributes<ForGraph> CONCENTRATE = new SingleAttributes<Boolean, ForGraph>("concentrate", true);
    public static final Attributes<ForGraph> FORCE_LABELS_NOT = new SingleAttributes<Boolean, ForGraph>("forcelabels", false);
    public static final Attributes<ForGraph> LANDSCAPE = new SingleAttributes<String, ForGraph>("orientation", "L");

    private GraphAttr() {
    }

    public static Attributes<ForGraph> dpi(int dpi) {
        return new SingleAttributes("dpi", dpi);
    }

    public static Attributes<ForGraph> sizeMax(double size2) {
        return new SingleAttributes(SIZE, size2);
    }

    public static Attributes<ForGraph> sizeMax(double sizeX, double sizeY) {
        return new SingleAttributes(SIZE, sizeX + "," + sizeY);
    }

    public static Attributes<ForGraph> sizePreferred(double size2) {
        return new SingleAttributes(SIZE, size2 + "!");
    }

    public static Attributes<ForGraph> sizePreferred(double sizeX, double sizeY) {
        return new SingleAttributes(SIZE, sizeX + "," + sizeY + "!");
    }

    public static Attributes<ForGraph> splines(SplineMode mode) {
        return new SingleAttributes("splines", mode.toString().toLowerCase(Locale.ENGLISH));
    }

    public static Attributes<ForGraph> pad(double pad) {
        return new SingleAttributes("pad", pad);
    }

    public static Attributes<ForGraph> pad(double padX, double padY) {
        return new SingleAttributes("pad", padX + "," + padY);
    }

    public static Attributes<ForGraph> margin(double margin) {
        return new SingleAttributes("margin", margin);
    }

    public static Attributes<ForGraph> margin(double marginX, double marginY) {
        return new SingleAttributes("margin", marginX + "," + marginY);
    }

    public static enum SplineMode {
        LINE,
        SPLINE,
        POLYLINE,
        ORTHO,
        CURVED,
        NONE;

    }
}

