/*
 * Decompiled with CFR 0.152.
 */
package coursier.cache;

import coursier.cache.ArchiveCache$;
import coursier.cache.ArchiveType;
import coursier.cache.ArchiveType$;
import coursier.cache.ArchiveType$Tar$;
import coursier.cache.ArtifactError;
import coursier.cache.Cache;
import coursier.cache.CacheLocks$;
import coursier.cache.CacheLogger;
import coursier.cache.CacheLogger$;
import coursier.cache.FileCache$;
import coursier.cache.UnArchiver;
import coursier.cache.UnArchiver$;
import coursier.core.Authentication;
import coursier.paths.CachePath;
import coursier.util.Artifact;
import coursier.util.Monad$ops$;
import coursier.util.Sync;
import coursier.util.Task;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import org.apache.tika.Tika;
import scala.$less$colon$less$;
import scala.Array;
import scala.Array$;
import scala.Array$UnapplySeqWrapper$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Using$;
import scala.util.Using$Releasable$AutoCloseableIsReleasable$;

@ScalaSignature(bytes="\u0006\u0005\tug\u0001B\u00181\u0005UB\u0001\u0002\u0014\u0001\u0003\u0006\u0004%\t!\u0014\u0005\t-\u0002\u0011\t\u0011)A\u0005\u001d\"A\u0011\u0007\u0001BC\u0002\u0013\u0005q\u000b\u0003\u0005k\u0001\t\u0005\t\u0015!\u0003Y\u0011!Y\u0007A!b\u0001\n\u0003a\u0007\u0002\u00039\u0001\u0005\u0003\u0005\u000b\u0011B7\t\u0011E\u0004!Q1A\u0005\u0002ID\u0001B\u001f\u0001\u0003\u0002\u0003\u0006Ia\u001d\u0005\tw\u0002\u0011)\u0019!C\u0002y\"I\u0011q\u0001\u0001\u0003\u0002\u0003\u0006I! \u0005\b\u0003\u0013\u0001A\u0011AA\u0006\u0011\u001d\tI\u0001\u0001C\u0001\u00037Aq!!\u0003\u0001\t\u0003\t9\u0003\u0003\u0004\u00020\u0001!I\u0001 \u0005\b\u0003c\u0001A\u0011BA\u001a\u0011\u001d\ty\u0004\u0001C\u0001\u0003\u0003Bq!a\u0010\u0001\t\u0003\tI\u0006\u0003\u0005\u0002h\u0001!\t\u0001MA5\u0011\u001d\ti\t\u0001C\u0001\u0003\u001fCq!a%\u0001\t\u0003\t)\nC\u0004\u0002\u001a\u0002!\t!a'\t\u000f\u0005}\u0005\u0001\"\u0001\u0002\"\"9\u0011Q\u0015\u0001\u0005\u0002\u0005\u001d\u0006bBAV\u0001\u0011\u0005\u0011Q\u0016\u0005\b\u0003c\u0003A\u0011IAZ\u0011\u001d\ty\f\u0001C!\u0003\u0003Dq!a2\u0001\t\u0003\nI\rC\u0004\u0002N\u0002!\t%a4\t\u000f\u0005]\u0007\u0001\"\u0003\u0002Z\"9\u0011\u0011\u001d\u0001\u0005B\u0005\r\bbBAs\u0001\u0011\u0005\u0013q\u001d\u0005\b\u0003S\u0004A\u0011IAv\u0011\u001d\t\t\u0010\u0001C!\u0003g<q!a>1\u0011\u0003\tIP\u0002\u00040a!\u0005\u00111 \u0005\b\u0003\u0013\u0019C\u0011\u0001B\u0001\u0011\u001d\u0011\u0019a\tC\u0001\u0005\u000bA\u0011Ba\u0007$#\u0003%\tA!\b\t\u000f\t\r3\u0005\"\u0001\u0003F!I!1L\u0012\u0012\u0002\u0013\u0005!Q\f\u0005\b\u0005K\u001aC\u0011\u0002B4\u0011\u001d\u0011\u0019h\tC\u0005\u0005kBqAa\u0001$\t\u0003\u0011\u0019\tC\u0004\u0003\u0004\r\"\tA!'\t\u000f\t\r1\u0005\"\u0001\u00036\"I!1[\u0012\u0002\u0002\u0013%!Q\u001b\u0002\r\u0003J\u001c\u0007.\u001b<f\u0007\u0006\u001c\u0007.\u001a\u0006\u0003cI\nQaY1dQ\u0016T\u0011aM\u0001\tG>,(o]5fe\u000e\u0001QC\u0001\u001c_'\u0011\u0001q'\u0010!\u0011\u0005aZT\"A\u001d\u000b\u0003i\nQa]2bY\u0006L!\u0001P\u001d\u0003\r\u0005s\u0017PU3g!\tAd(\u0003\u0002@s\t9\u0001K]8ek\u000e$\bCA!J\u001d\t\u0011uI\u0004\u0002D\r6\tAI\u0003\u0002Fi\u00051AH]8pizJ\u0011AO\u0005\u0003\u0011f\nq\u0001]1dW\u0006<W-\u0003\u0002K\u0017\na1+\u001a:jC2L'0\u00192mK*\u0011\u0001*O\u0001\tY>\u001c\u0017\r^5p]V\ta\n\u0005\u0002P)6\t\u0001K\u0003\u0002R%\u0006\u0011\u0011n\u001c\u0006\u0002'\u0006!!.\u0019<b\u0013\t)\u0006K\u0001\u0003GS2,\u0017!\u00037pG\u0006$\u0018n\u001c8!+\u0005A\u0006cA-[96\t\u0001'\u0003\u0002\\a\t)1)Y2iKB\u0011QL\u0018\u0007\u0001\t\u0015y\u0006A1\u0001a\u0005\u00051UCA1i#\t\u0011W\r\u0005\u00029G&\u0011A-\u000f\u0002\b\u001d>$\b.\u001b8h!\tAd-\u0003\u0002hs\t\u0019\u0011I\\=\u0005\u000b%t&\u0019A1\u0003\t}#C%M\u0001\u0007G\u0006\u001c\u0007.\u001a\u0011\u0002\u0015Ut\u0017I]2iSZ,'/F\u0001n!\tIf.\u0003\u0002pa\tQQK\\!sG\"Lg/\u001a:\u0002\u0017Ut\u0017I]2iSZ,'\u000fI\u0001\u000b_B,gn\u0015;sK\u0006lW#A:\u0011\u0005Q<hBA-v\u0013\t1\b'\u0001\u0006V]\u0006\u00138\r[5wKJL!\u0001_=\u0003\u0015=\u0003XM\\*ue\u0016\fWN\u0003\u0002wa\u0005Yq\u000e]3o'R\u0014X-Y7!\u0003\u0011\u0019\u0018P\\2\u0016\u0003u\u0004BA`A\u000296\tqPC\u0002\u0002\u0002I\nA!\u001e;jY&\u0019\u0011QA@\u0003\tMKhnY\u0001\u0006gft7\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0015\u00055\u00111CA\u000b\u0003/\tI\u0002\u0006\u0003\u0002\u0010\u0005E\u0001cA-\u00019\")1p\u0003a\u0002{\")Aj\u0003a\u0001\u001d\")\u0011g\u0003a\u00011\")1n\u0003a\u0001[\")\u0011o\u0003a\u0001gRA\u0011QDA\u0011\u0003G\t)\u0003\u0006\u0003\u0002\u0010\u0005}\u0001\"B>\r\u0001\bi\b\"\u0002'\r\u0001\u0004q\u0005\"B\u0019\r\u0001\u0004A\u0006\"B6\r\u0001\u0004iG\u0003BA\u0015\u0003[!B!a\u0004\u0002,!)10\u0004a\u0002{\")A*\u0004a\u0001\u001d\u0006\t1+\u0001\u0005m_\u000e\fG\u000eR5s)\rq\u0015Q\u0007\u0005\b\u0003oy\u0001\u0019AA\u001d\u0003!\t'\u000f^5gC\u000e$\bc\u0001@\u0002<%\u0019\u0011QH@\u0003\u0011\u0005\u0013H/\u001b4bGR\f1bZ3u\u0013\u001a,\u00050[:ugR!\u00111IA,!\u0011if,!\u0012\u0011\u000f\u0005\u000b9%a\u0013\u0002R%\u0019\u0011\u0011J&\u0003\r\u0015KG\u000f[3s!\rI\u0016QJ\u0005\u0004\u0003\u001f\u0002$!D!si&4\u0017m\u0019;FeJ|'\u000f\u0005\u00039\u0003'r\u0015bAA+s\t1q\n\u001d;j_:Dq!a\u000e\u0011\u0001\u0004\tI\u0004\u0006\u0004\u0002D\u0005m\u0013Q\f\u0005\b\u0003o\t\u0002\u0019AA\u001d\u0011\u001d\ty&\u0005a\u0001\u0003C\nA\"[:TS:<G.\u001a$jY\u0016\u00042\u0001OA2\u0013\r\t)'\u000f\u0002\b\u0005>|G.Z1o\u0003\u00119W\r\u001e\u0019\u0015\u0011\u0005-\u0014qNA:\u0003\u0013\u0003B!\u00180\u0002nA1\u0011)a\u0012\u0002L9Ca!!\u001d\u0013\u0001\u0004q\u0015a\u00013je\"9\u0011Q\u000f\nA\u0002\u0005]\u0014AB;sY>\u0003H\u000fE\u00039\u0003'\nI\b\u0005\u0003\u0002|\u0005\re\u0002BA?\u0003\u007f\u0002\"aQ\u001d\n\u0007\u0005\u0005\u0015(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u000b\u000b9I\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0003K\u0004bBAF%\u0001\u0007\u00111N\u0001\tI><h\u000e\\8bI\u0006\u0019q-\u001a;\u0015\t\u0005-\u0014\u0011\u0013\u0005\b\u0003o\u0019\u0002\u0019AA\u001d\u000319\u0018\u000e\u001e5M_\u000e\fG/[8o)\u0011\ty!a&\t\u000b1#\u0002\u0019\u0001(\u0002\u0013]LG\u000f[\"bG\",G\u0003BA\b\u0003;CQ!M\u000bA\u0002a\u000bab^5uQVs\u0017I]2iSZ,'\u000f\u0006\u0003\u0002\u0010\u0005\r\u0006\"B6\u0017\u0001\u0004i\u0017AD<ji\"|\u0005/\u001a8TiJ,\u0017-\u001c\u000b\u0005\u0003\u001f\tI\u000bC\u0003r/\u0001\u00071/\u0001\u0005xSRD7+\u001f8d)\u0011\ty!a,\t\u000bmD\u0002\u0019A?\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!.\u0011\t\u0005]\u0016QX\u0007\u0003\u0003sS1!a/S\u0003\u0011a\u0017M\\4\n\t\u0005\u0015\u0015\u0011X\u0001\tG\u0006tW)];bYR!\u0011\u0011MAb\u0011\u0019\t)M\u0007a\u0001K\u0006\u0019qN\u00196\u0002\r\u0015\fX/\u00197t)\u0011\t\t'a3\t\r\u0005\u00157\u00041\u0001f\u0003!A\u0017m\u001d5D_\u0012,GCAAi!\rA\u00141[\u0005\u0004\u0003+L$aA%oi\u0006)A/\u001e9mKV\u0011\u00111\u001c\t\tq\u0005ug\nW7t{&\u0019\u0011q\\\u001d\u0003\rQ+\b\u000f\\36\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011QW\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003#\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002f\u0003[Dq!a<!\u0001\u0004\t\t.A\u0001o\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005U\u0016Q\u001f\u0005\b\u0003_\f\u0003\u0019AAi\u00031\t%o\u00195jm\u0016\u001c\u0015m\u00195f!\tI6e\u0005\u0003$o\u0005u\bcA(\u0002\u0000&\u0011!\n\u0015\u000b\u0003\u0003s\fQ!\u00199qYf,BAa\u0002\u0003\u0010Q\u0011!\u0011\u0002\u000b\u0005\u0005\u0017\u00119\u0002\u0005\u0003Z\u0001\t5\u0001cA/\u0003\u0010\u00111q,\nb\u0001\u0005#)2!\u0019B\n\t\u001d\u0011)Ba\u0004C\u0002\u0005\u0014Aa\u0018\u0013%e!I\u0011qF\u0013\u0011\u0002\u0003\u000f!\u0011\u0004\t\u0006}\u0006\r!QB\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%cU!!q\u0004B\u001f)\t\u0011\tC\u000b\u0003\u0003$\t-\u0002#\u0002@\u0002\u0004\t\u0015\u0002c\u0001@\u0003(%\u0019!\u0011F@\u0003\tQ\u000b7o[\u0016\u0003\u0005[\u0001BAa\f\u0003:5\u0011!\u0011\u0007\u0006\u0005\u0005g\u0011)$A\u0005v]\u000eDWmY6fI*\u0019!qG\u001d\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003<\tE\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u00121qL\nb\u0001\u0005\u007f)2!\u0019B!\t\u001d\u0011)B!\u0010C\u0002\u0005\f1\u0002\u001d:jm&dW\rZ4fIV!!q\tB()\t\u0011I\u0005\u0006\u0003\u0003L\t]\u0003\u0003B-\u0001\u0005\u001b\u00022!\u0018B(\t\u0019yvE1\u0001\u0003RU\u0019\u0011Ma\u0015\u0005\u000f\tU#q\nb\u0001C\n!q\f\n\u00134\u0011%\tyc\nI\u0001\u0002\b\u0011I\u0006E\u0003\u007f\u0003\u0007\u0011i%A\u000bqe&4\u0018\u000e\\3eO\u0016$G\u0005Z3gCVdG\u000fJ\u0019\u0016\t\t}!q\f\u0003\u0007?\"\u0012\rA!\u0019\u0016\u0007\u0005\u0014\u0019\u0007B\u0004\u0003V\t}#\u0019A1\u0002\u001f\u0011,G.\u001a;f%\u0016\u001cWO]:jm\u0016$BA!\u001b\u0003pA\u0019\u0001Ha\u001b\n\u0007\t5\u0014H\u0001\u0003V]&$\bB\u0002B9S\u0001\u0007a*A\u0001g\u0003-\t'o\u00195jm\u0016$\u0016\u0010]3\u0015\t\t]$q\u0010\t\u0006q\u0005M#\u0011\u0010\t\u00043\nm\u0014b\u0001B?a\tY\u0011I]2iSZ,G+\u001f9f\u0011\u001d\u0011\tI\u000ba\u0001\u0003s\n1!\u001e:m+\u0011\u0011)I!$\u0015\t\t\u001d%q\u0013\u000b\u0005\u0005\u0013\u0013\u0019\n\u0005\u0003Z\u0001\t-\u0005cA/\u0003\u000e\u00121ql\u000bb\u0001\u0005\u001f+2!\u0019BI\t\u0019I'Q\u0012b\u0001C\"11p\u000ba\u0002\u0005+\u0003RA`A\u0002\u0005\u0017CQ\u0001T\u0016A\u00029+BAa'\u0003$RA!Q\u0014BW\u0005_\u0013\u0019\f\u0006\u0003\u0003 \n%\u0006\u0003B-\u0001\u0005C\u00032!\u0018BR\t\u0019yFF1\u0001\u0003&V\u0019\u0011Ma*\u0005\r%\u0014\u0019K1\u0001b\u0011\u0019YH\u0006q\u0001\u0003,B)a0a\u0001\u0003\"\")A\n\fa\u0001\u001d\"1\u0011\u0007\fa\u0001\u0005c\u0003B!\u0017.\u0003\"\")1\u000e\fa\u0001[V!!q\u0017B`))\u0011IL!3\u0003L\n='\u0011\u001b\u000b\u0005\u0005w\u0013)\r\u0005\u0003Z\u0001\tu\u0006cA/\u0003@\u00121q,\fb\u0001\u0005\u0003,2!\u0019Bb\t\u0019I'q\u0018b\u0001C\"110\fa\u0002\u0005\u000f\u0004RA`A\u0002\u0005{CQ\u0001T\u0017A\u00029Ca!M\u0017A\u0002\t5\u0007\u0003B-[\u0005{CQa[\u0017A\u00025DQ!]\u0017A\u0002M\fAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"Aa6\u0011\t\u0005]&\u0011\\\u0005\u0005\u00057\fIL\u0001\u0004PE*,7\r\u001e")
public final class ArchiveCache<F>
implements Product,
Serializable {
    private final File location;
    private final Cache<F> cache;
    private final UnArchiver unArchiver;
    private final UnArchiver.OpenStream openStream;
    private final Sync<F> sync;

    public static <F> ArchiveCache<F> apply(File location, Cache<F> cache, UnArchiver unArchiver, UnArchiver.OpenStream openStream, Sync<F> sync) {
        return ArchiveCache$.MODULE$.apply(location, cache, unArchiver, openStream, sync);
    }

    public static <F> ArchiveCache<F> apply(File location, Cache<F> cache, UnArchiver unArchiver, Sync<F> sync) {
        return ArchiveCache$.MODULE$.apply(location, cache, unArchiver, sync);
    }

    public static <F> ArchiveCache<F> apply(File location, Sync<F> sync) {
        return ArchiveCache$.MODULE$.apply(location, sync);
    }

    public static <F> Sync<Task> priviledged$default$1() {
        return ArchiveCache$.MODULE$.priviledged$default$1();
    }

    public static <F> ArchiveCache<F> priviledged(Sync<F> S) {
        return ArchiveCache$.MODULE$.priviledged(S);
    }

    public static <F> Sync<Task> apply$default$1() {
        return ArchiveCache$.MODULE$.apply$default$1();
    }

    public static <F> ArchiveCache<F> apply(Sync<F> S) {
        return ArchiveCache$.MODULE$.apply(S);
    }

    @Override
    public Iterator<Object> productIterator() {
        return Product.productIterator$(this);
    }

    @Override
    public Iterator<String> productElementNames() {
        return Product.productElementNames$(this);
    }

    public File location() {
        return this.location;
    }

    public Cache<F> cache() {
        return this.cache;
    }

    public UnArchiver unArchiver() {
        return this.unArchiver;
    }

    public UnArchiver.OpenStream openStream() {
        return this.openStream;
    }

    public Sync<F> sync() {
        return this.sync;
    }

    private Sync<F> S() {
        return this.sync();
    }

    private File localDir(Artifact artifact) {
        return CachePath.localFile(artifact.url(), this.location(), (String)artifact.authentication().flatMap((Function1<Authentication, Option> & Serializable)x$1 -> x$1.userOpt()).orNull($less$colon$less$.MODULE$.refl()), true);
    }

    public F getIfExists(Artifact artifact) {
        Option<ArchiveType> option = ArchiveCache$.MODULE$.coursier$cache$ArchiveCache$$archiveType(artifact.url());
        if (option instanceof Some) {
            Some some = (Some)option;
            ArchiveType archiveType0 = (ArchiveType)some.value();
            return this.getIfExists(artifact, archiveType0.singleFile());
        }
        if (None$.MODULE$.equals(option)) {
            return this.S().point(new Left(new ArtifactError.DownloadError(new StringBuilder(39).append("Cannot get archive format from URL for ").append(artifact.url()).toString(), None$.MODULE$)));
        }
        throw new MatchError(option);
    }

    public F getIfExists(Artifact artifact, boolean isSingleFile) {
        File dir = this.localDir(artifact);
        Object dirTask = Monad$ops$.MODULE$.toAllMonadOps(this.S().delay(() -> dir.exists()), this.sync()).map((Function1<Object, Either> & Serializable)x0$1 -> ArchiveCache.$anonfun$getIfExists$2(dir, BoxesRunTime.unboxToBoolean(x0$1)));
        if (isSingleFile) {
            return Monad$ops$.MODULE$.toAllMonadOps(dirTask, this.sync()).flatMap((Function1<Either, Object> & Serializable)x0$2 -> {
                Right right;
                Option option;
                Either either = x0$2;
                if (either instanceof Right && (option = (Option)(right = (Right)either).value()) instanceof Some) {
                    Some some = (Some)option;
                    File dir = (File)some.value();
                    return this.S().delay((Function0<Either> & Serializable)() -> {
                        Object object;
                        File[] fileArray = dir.listFiles();
                        if (fileArray != null && !Array$UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq(fileArray)) && new Array.UnapplySeqWrapper(Array$UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 1) == 0) {
                            File f = (File)Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
                            return new Right(new Some<File>(f));
                        }
                        return new Right(new Some<File>(dir));
                    });
                }
                return this.S().point(either);
            });
        }
        return dirTask;
    }

    public F get0(File dir, Option<String> urlOpt, F download) {
        Object dirTask = Monad$ops$.MODULE$.toAllMonadOps(this.S().delay(() -> dir.exists()), this.sync()).flatMap((Function1<Object, Object> & Serializable)exists2 -> ArchiveCache.$anonfun$get0$10(this, download, urlOpt, dir, BoxesRunTime.unboxToBoolean(exists2)));
        return Monad$ops$.MODULE$.toAllMonadOps(dirTask, this.sync()).flatMap((Function1<Either, Object> & Serializable)x0$2 -> {
            Right right;
            Tuple2 tuple2;
            Either either = x0$2;
            if (either instanceof Right && (tuple2 = (Tuple2)(right = (Right)either).value()) != null) {
                File dir = (File)tuple2._1();
                ArchiveType arcType = (ArchiveType)tuple2._2();
                if (arcType.singleFile()) {
                    return this.S().delay((Function0<Right> & Serializable)() -> {
                        File f;
                        Object object;
                        File[] fileArray = dir.listFiles();
                        return new Right(fileArray != null && !Array$UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq(fileArray)) && new Array.UnapplySeqWrapper(Array$UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 1) == 0 ? (f = (File)Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 0)) : dir);
                    });
                }
            }
            return this.S().point(either.map((Function1<Tuple2, File> & Serializable)x$3 -> (File)x$3._1()));
        });
    }

    public F get(Artifact artifact) {
        File dir = this.localDir(artifact);
        Some<String> urlOpt = new Some<String>(artifact.url());
        Object download = ((CacheLogger)this.cache().loggerOpt().getOrElse((Function0<CacheLogger> & Serializable)() -> CacheLogger$.MODULE$.nop())).using().apply(this.cache().file(artifact).run(), this.sync());
        return this.get0(dir, urlOpt, download);
    }

    public ArchiveCache<F> withLocation(File location) {
        return new ArchiveCache<F>(location, this.cache(), this.unArchiver(), this.openStream(), this.sync());
    }

    public ArchiveCache<F> withCache(Cache<F> cache) {
        return new ArchiveCache<F>(this.location(), cache, this.unArchiver(), this.openStream(), this.sync());
    }

    public ArchiveCache<F> withUnArchiver(UnArchiver unArchiver) {
        return new ArchiveCache<F>(this.location(), this.cache(), unArchiver, this.openStream(), this.sync());
    }

    public ArchiveCache<F> withOpenStream(UnArchiver.OpenStream openStream) {
        return new ArchiveCache<F>(this.location(), this.cache(), this.unArchiver(), openStream, this.sync());
    }

    public ArchiveCache<F> withSync(Sync<F> sync) {
        return new ArchiveCache<F>(this.location(), this.cache(), this.unArchiver(), this.openStream(), sync);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("ArchiveCache(");
        b.append(String.valueOf(this.location()));
        b.append(", ");
        b.append(String.valueOf(this.cache()));
        b.append(", ");
        b.append(String.valueOf(this.unArchiver()));
        b.append(", ");
        b.append(String.valueOf(this.openStream()));
        b.append(", ");
        b.append(String.valueOf(this.sync()));
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj != null && obj instanceof ArchiveCache && true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!this.canEqual(obj)) return false;
        ArchiveCache other = (ArchiveCache)obj;
        if (!true) return false;
        File file = this.location();
        File file2 = other.location();
        if (file == null) {
            if (file2 != null) {
                return false;
            }
        } else if (!((Object)file).equals(file2)) return false;
        Cache<F> cache = this.cache();
        Cache<F> cache2 = other.cache();
        if (cache == null) {
            if (cache2 != null) {
                return false;
            }
        } else if (!cache.equals(cache2)) return false;
        UnArchiver unArchiver = this.unArchiver();
        UnArchiver unArchiver2 = other.unArchiver();
        if (unArchiver == null) {
            if (unArchiver2 != null) {
                return false;
            }
        } else if (!unArchiver.equals(unArchiver2)) return false;
        UnArchiver.OpenStream openStream = this.openStream();
        UnArchiver.OpenStream openStream2 = other.openStream();
        if (openStream == null) {
            if (openStream2 != null) {
                return false;
            }
        } else if (!openStream.equals(openStream2)) return false;
        Sync<F> sync = this.sync();
        Sync<F> sync2 = other.sync();
        if (sync == null) {
            if (sync2 == null) return true;
            return false;
        } else {
            if (!sync.equals(sync2)) return false;
            return true;
        }
    }

    public int hashCode() {
        int code = 17 + Statics.anyHash("ArchiveCache");
        code = 37 * code + Statics.anyHash(this.location());
        code = 37 * code + Statics.anyHash(this.cache());
        code = 37 * code + Statics.anyHash(this.unArchiver());
        code = 37 * code + Statics.anyHash(this.openStream());
        code = 37 * code + Statics.anyHash(this.sync());
        return 37 * code;
    }

    private Tuple5<File, Cache<F>, UnArchiver, UnArchiver.OpenStream, Sync<F>> tuple() {
        return new Tuple5<File, Cache<F>, UnArchiver, UnArchiver.OpenStream, Sync<F>>(this.location(), this.cache(), this.unArchiver(), this.openStream(), this.sync());
    }

    @Override
    public String productPrefix() {
        return "ArchiveCache";
    }

    @Override
    public int productArity() {
        return 5;
    }

    @Override
    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this.location();
            }
            case 1: {
                return this.cache();
            }
            case 2: {
                return this.unArchiver();
            }
            case 3: {
                return this.openStream();
            }
            case 4: {
                return this.sync();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(n2));
    }

    @Override
    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "location";
            }
            case 1: {
                return "cache";
            }
            case 2: {
                return "unArchiver";
            }
            case 3: {
                return "openStream";
            }
            case 4: {
                return "sync";
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(n2));
    }

    public static final /* synthetic */ Either $anonfun$getIfExists$2(File dir$1, boolean x0$1) {
        boolean bl = x0$1;
        if (bl) {
            return new Right(new Some<File>(dir$1));
        }
        if (!bl) {
            return new Right(None$.MODULE$);
        }
        throw new MatchError(BoxesRunTime.boxToBoolean(bl));
    }

    private final Either maybeArchiveType$1(File f, Option urlOpt) {
        return (Either)urlOpt.flatMap((Function1<String, Option> & Serializable)url -> ArchiveCache$.MODULE$.coursier$cache$ArchiveCache$$archiveType((String)url)).map((Function1<ArchiveType, Right> & Serializable)x$2 -> new Right((ArchiveType)x$2)).getOrElse((Function0<Either> & Serializable)() -> {
            Tika tika = new Tika();
            String mimeType = (String)Using$.MODULE$.resource(Files.newInputStream(f.toPath(), new OpenOption[0]), (Function1<InputStream, String> & Serializable)is -> tika.detect((InputStream)is), Using$Releasable$AutoCloseableIsReleasable$.MODULE$);
            boolean bl = false;
            Some some = null;
            Option<ArchiveType> option = ArchiveType$.MODULE$.fromMimeType(mimeType);
            if (option instanceof Some) {
                bl = true;
                some = (Some)option;
                ArchiveType compressed = (ArchiveType)some.value();
                if (compressed instanceof ArchiveType.Compressed) {
                    Some some2;
                    ArchiveType archiveType;
                    ArchiveType.Compressed compressed2 = (ArchiveType.Compressed)compressed;
                    String t0 = (String)Using$.MODULE$.resource(Files.newInputStream(f.toPath(), new OpenOption[0]), (Function1<InputStream, String> & Serializable)is -> {
                        Tika tika = new Tika();
                        return tika.detect(this.openStream().inputStream(compressed2, (InputStream)is));
                    }, Using$Releasable$AutoCloseableIsReleasable$.MODULE$);
                    Option<ArchiveType> option2 = ArchiveType$.MODULE$.fromMimeType(t0);
                    return new Right((ArchiveType.Compressed)(option2 instanceof Some && ArchiveType$Tar$.MODULE$.equals(archiveType = (ArchiveType)(some2 = (Some)option2).value()) ? compressed2.tar() : compressed2));
                }
            }
            if (bl) {
                ArchiveType tpe = (ArchiveType)some.value();
                return new Right(tpe);
            }
            if (None$.MODULE$.equals(option)) {
                return new Left(new ArtifactError.DownloadError(new StringBuilder(72).append("Cannot detect archive type of ").append(f).append(", or unsupported archive type (MIME type ").append(mimeType).append(")").toString(), None$.MODULE$));
            }
            throw new MatchError(option);
        });
    }

    private static final void moveToDest$1(File tmp$1, File dir$3) {
        Files.move(tmp$1.toPath(), dir$3.toPath(), StandardCopyOption.ATOMIC_MOVE);
    }

    private final Object extract$1(File f, boolean deleteDest, ArchiveType archiveType0, File dir$3) {
        return this.S().delay((Function0<Right> & Serializable)() -> {
            ArchiveType archiveType1 = (ArchiveType)CacheLocks$.MODULE$.withLockOr(this.location(), dir$3, (Function0<ArchiveType> & Serializable)() -> {
                block4: {
                    if (!deleteDest && dir$3.exists()) break block4;
                    File tmp = CachePath.temporaryFile(dir$3);
                    ArchiveCache$.MODULE$.coursier$cache$ArchiveCache$$deleteRecursive(tmp);
                    Files.createDirectories(tmp.toPath(), new FileAttribute[0]);
                    this.unArchiver().extract(archiveType0, f, tmp, false);
                    FileTime lastModifiedTime = Files.getLastModifiedTime(f.toPath(), new LinkOption[0]);
                    Files.setLastModifiedTime(tmp.toPath(), lastModifiedTime);
                    if (dir$3.exists()) {
                        if (deleteDest) {
                            ArchiveCache$.MODULE$.coursier$cache$ArchiveCache$$deleteRecursive(dir$3);
                            ArchiveCache.moveToDest$1(tmp, dir$3);
                        } else {
                            ArchiveCache$.MODULE$.coursier$cache$ArchiveCache$$deleteRecursive(tmp);
                        }
                    } else {
                        ArchiveCache.moveToDest$1(tmp, dir$3);
                    }
                }
                return archiveType0;
            }, (Function0<None$> & Serializable)() -> {
                Thread.sleep(50L);
                return None$.MODULE$;
            });
            return new Right(new Tuple2<File, ArchiveType>(dir$3, archiveType1));
        });
    }

    public static final /* synthetic */ Object $anonfun$get0$10(ArchiveCache $this, Object download$1, Option urlOpt$1, File dir$3, boolean exists2) {
        return Monad$ops$.MODULE$.toAllMonadOps(download$1, $this.sync()).flatMap((Function1<Either, Object> & Serializable)x0$1 -> {
            Either either = x0$1;
            if (either instanceof Left) {
                Left left = (Left)either;
                ArtifactError err = (ArtifactError)left.value();
                return $this.S().point(new Left(err));
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                File f = (File)right.value();
                Either either2 = $this.maybeArchiveType$1(f, urlOpt$1);
                if (either2 instanceof Left) {
                    Left left = (Left)either2;
                    ArtifactError err = (ArtifactError)left.value();
                    return $this.S().point(new Left(err));
                }
                if (either2 instanceof Right) {
                    Right right2 = (Right)either2;
                    ArchiveType archiveType0 = (ArchiveType)right2.value();
                    if (exists2) {
                        FileTime archiveLastModifiedTime = Files.getLastModifiedTime(f.toPath(), new LinkOption[0]);
                        FileTime dirLastModifiedTime = Files.getLastModifiedTime(dir$3.toPath(), new LinkOption[0]);
                        FileTime fileTime = archiveLastModifiedTime;
                        FileTime fileTime2 = dirLastModifiedTime;
                        if (!(fileTime != null ? !((Object)fileTime).equals(fileTime2) : fileTime2 != null)) {
                            return $this.S().point(new Right(new Tuple2<File, ArchiveType>(dir$3, archiveType0)));
                        }
                        return $this.extract$1(f, true, archiveType0, dir$3);
                    }
                    return $this.extract$1(f, false, archiveType0, dir$3);
                }
                throw new MatchError(either2);
            }
            throw new MatchError(either);
        });
    }

    public ArchiveCache(File location, Cache<F> cache, UnArchiver unArchiver, UnArchiver.OpenStream openStream, Sync<F> sync) {
        this.location = location;
        this.cache = cache;
        this.unArchiver = unArchiver;
        this.openStream = openStream;
        this.sync = sync;
        Product.$init$(this);
    }

    public ArchiveCache(File location, Cache<F> cache, UnArchiver unArchiver, Sync<F> sync) {
        this(location, cache, unArchiver, (UnArchiver.OpenStream)((Object)UnArchiver$.MODULE$.default()), sync);
    }

    public ArchiveCache(File location, Sync<F> sync) {
        this(location, FileCache$.MODULE$.apply(sync), UnArchiver$.MODULE$.default(), (UnArchiver.OpenStream)((Object)UnArchiver$.MODULE$.default()), sync);
    }
}

