/*
 * Decompiled with CFR 0.152.
 */
package com.eed3si9n.jarjar.util;

import com.eed3si9n.jarjar.TracingRemapper;
import com.eed3si9n.jarjar.misplaced.MisplacedClassProcessor;
import com.eed3si9n.jarjar.util.EntryStruct;
import com.eed3si9n.jarjar.util.GetNameClassWriter;
import com.eed3si9n.jarjar.util.RemappingJarProcessor;
import java.io.IOException;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.commons.Remapper;

public abstract class JarTransformer
extends RemappingJarProcessor {
    public JarTransformer(TracingRemapper tracingRemapper) {
        super(tracingRemapper);
    }

    @Override
    public boolean processImpl(EntryStruct entryStruct, Remapper remapper) throws IOException {
        if (entryStruct.name.endsWith(".class") && !entryStruct.skipTransform) {
            ClassReader classReader;
            try {
                classReader = new ClassReader(entryStruct.data);
            }
            catch (RuntimeException runtimeException) {
                System.err.println("Unable to read bytecode from " + entryStruct.name);
                runtimeException.printStackTrace();
                return true;
            }
            GetNameClassWriter getNameClassWriter = new GetNameClassWriter(1);
            try {
                classReader.accept(this.transform(getNameClassWriter, remapper), 8);
            }
            catch (RuntimeException runtimeException) {
                throw new IOException("Unable to transform " + entryStruct.name, runtimeException);
            }
            entryStruct.data = getNameClassWriter.toByteArray();
            String string = entryStruct.name.startsWith(MisplacedClassProcessor.VERSIONED_CLASS_FOLDER) ? entryStruct.name.substring(0, entryStruct.name.indexOf("/", MisplacedClassProcessor.VERSIONED_CLASS_FOLDER.length()) + 1) : "";
            entryStruct.name = string + JarTransformer.pathFromName(getNameClassWriter.getClassName());
        }
        return true;
    }

    protected abstract ClassVisitor transform(ClassVisitor var1, Remapper var2);

    private static String pathFromName(String string) {
        return string.replace('.', '/') + ".class";
    }
}

