/*
 * Decompiled with CFR 0.152.
 */
package com.eed3si9n.jarjar;

import com.eed3si9n.jarjar.TracingRemapper;
import com.eed3si9n.jarjar.util.EntryStruct;
import com.eed3si9n.jarjar.util.RemappingJarProcessor;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.Remapper;

public class MethodSignatureProcessor
extends RemappingJarProcessor {
    private static final Set<String> METHOD_NAMES_WITH_PARAMS_TO_REWRITE = new HashSet<String>(Arrays.asList("getImplMethodSignature"));

    public MethodSignatureProcessor(TracingRemapper tracingRemapper) {
        super(tracingRemapper);
    }

    @Override
    public boolean processImpl(EntryStruct entryStruct, Remapper remapper) throws IOException {
        ClassReader classReader;
        if (!entryStruct.name.endsWith(".class") || entryStruct.skipTransform) {
            return true;
        }
        ClassWriter classWriter = new ClassWriter(1);
        try {
            classReader = new ClassReader(entryStruct.data);
        }
        catch (RuntimeException runtimeException) {
            System.err.println("Unable to read bytecode from " + entryStruct.name);
            runtimeException.printStackTrace();
            return true;
        }
        classReader.accept(new MethodSignatureRemapperClassVisitor(classWriter, remapper), 8);
        entryStruct.data = classWriter.toByteArray();
        return true;
    }

    private static class MethodSignatureRemapperClassVisitor
    extends ClassVisitor {
        private final Remapper remapper;

        public MethodSignatureRemapperClassVisitor(ClassVisitor classVisitor, Remapper remapper) {
            super(589824, classVisitor);
            this.remapper = remapper;
        }

        @Override
        public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
            return new MethodSignatureRemapperMethodVisitor(this.cv.visitMethod(n, string, string2, string3, stringArray));
        }

        private class MethodSignatureRemapperMethodVisitor
        extends MethodVisitor {
            private boolean rewriteNextLdcInstruction;

            private MethodSignatureRemapperMethodVisitor(MethodVisitor methodVisitor) {
                super(589824, methodVisitor);
                this.rewriteNextLdcInstruction = false;
            }

            private boolean shouldMarkNextLdcForRewrite(int n, String string) {
                return n == 182 && METHOD_NAMES_WITH_PARAMS_TO_REWRITE.contains(string);
            }

            @Override
            public void visitMethodInsn(int n, String string, String string2, String string3) {
                this.rewriteNextLdcInstruction = this.shouldMarkNextLdcForRewrite(n, string2);
                this.mv.visitMethodInsn(n, string, string2, string3);
            }

            @Override
            public void visitMethodInsn(int n, String string, String string2, String string3, boolean bl) {
                this.rewriteNextLdcInstruction = this.shouldMarkNextLdcForRewrite(n, string2);
                this.mv.visitMethodInsn(n, string, string2, string3, bl);
            }

            @Override
            public void visitLdcInsn(Object object) {
                if (this.rewriteNextLdcInstruction && object instanceof String) {
                    this.rewriteNextLdcInstruction = false;
                    this.mv.visitLdcInsn(MethodSignatureRemapperClassVisitor.this.remapper.mapSignature((String)object, false));
                } else {
                    this.mv.visitLdcInsn(object);
                }
            }
        }
    }
}

