/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.v8;

import com.eclipsesource.v8.JavaCallback;
import com.eclipsesource.v8.JavaVoidCallback;
import com.eclipsesource.v8.Releasable;
import com.eclipsesource.v8.V8;
import com.eclipsesource.v8.V8Array;
import com.eclipsesource.v8.V8Function;
import com.eclipsesource.v8.V8Object;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;

public class NodeJS {
    private static final String TMP_JS_EXT = ".js.tmp";
    private static final String NEXT_TICK = "nextTick";
    private static final String PROCESS = "process";
    private static final String GLOBAL = "global";
    private static final String STARTUP_CALLBACK = "__run";
    private static final String STARTUP_SCRIPT = "global.__run(require, exports, module, __filename, __dirname);";
    private static final String STARTUP_SCRIPT_NAME = "startup";
    private V8 v8;
    private V8Function require;

    public static NodeJS createNodeJS() {
        return NodeJS.createNodeJS(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NodeJS createNodeJS(File file) {
        V8 v8 = V8.createV8Runtime(GLOBAL);
        final NodeJS node = new NodeJS(v8);
        v8.registerJavaMethod(new JavaVoidCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void invoke(V8Object receiver, V8Array parameters) {
                V8Function require = (V8Function)parameters.get(0);
                try {
                    node.init(require.twin());
                }
                finally {
                    require.release();
                }
            }
        }, STARTUP_CALLBACK);
        try {
            File startupScript = NodeJS.createTemporaryScriptFile(STARTUP_SCRIPT, STARTUP_SCRIPT_NAME);
            try {
                v8.createNodeRuntime(startupScript.getAbsolutePath());
            }
            finally {
                startupScript.delete();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (file != null) {
            node.exec(file);
        }
        return node;
    }

    public V8 getRuntime() {
        return this.v8;
    }

    public boolean handleMessage() {
        this.v8.checkThread();
        return this.v8.pumpMessageLoop();
    }

    public void release() {
        this.v8.checkThread();
        if (!this.require.isReleased()) {
            this.require.release();
        }
        if (!this.v8.isReleased()) {
            this.v8.release();
        }
    }

    public boolean isRunning() {
        this.v8.checkThread();
        return this.v8.isRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V8Object require(File file) {
        this.v8.checkThread();
        V8Array requireParams = new V8Array(this.v8);
        try {
            requireParams.push(file.getAbsolutePath());
            V8Object v8Object = (V8Object)this.require.call(null, requireParams);
            return v8Object;
        }
        finally {
            requireParams.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exec(File file) {
        V8Function scriptExecution = this.createScriptExecutionCallback(file);
        V8Object process = null;
        V8Array parameters = null;
        try {
            process = this.v8.getObject(PROCESS);
            parameters = new V8Array(this.v8);
            parameters.push(scriptExecution);
            process.executeObjectFunction(NEXT_TICK, parameters);
            this.safeRelease(process);
            this.safeRelease(parameters);
            this.safeRelease(scriptExecution);
        }
        catch (Throwable throwable) {
            this.safeRelease(process);
            this.safeRelease(parameters);
            this.safeRelease(scriptExecution);
            throw throwable;
        }
    }

    private V8Function createScriptExecutionCallback(final File file) {
        V8Function v8Function = new V8Function(this.v8, new JavaCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object invoke(V8Object receiver, V8Array parameters) {
                V8Array requireParams = new V8Array(NodeJS.this.v8);
                try {
                    requireParams.push(file.getAbsolutePath());
                    Object object = NodeJS.this.require.call(null, requireParams);
                    return object;
                }
                finally {
                    requireParams.release();
                }
            }
        });
        return v8Function;
    }

    private void safeRelease(Releasable releasable) {
        if (releasable != null) {
            releasable.release();
        }
    }

    private NodeJS(V8 v8) {
        this.v8 = v8;
    }

    private void init(V8Function require) {
        this.require = require;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File createTemporaryScriptFile(String script, String name) throws IOException {
        File tempFile = File.createTempFile(name, TMP_JS_EXT);
        PrintWriter writer = new PrintWriter(tempFile, "UTF-8");
        try {
            writer.print(script);
        }
        finally {
            writer.close();
        }
        return tempFile;
    }
}

