/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.resolution.failure.exception;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.gradle.api.internal.catalog.problems.ResolutionFailureProblemId;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.problems.DocLink;
import org.gradle.api.problems.Problem;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.GradleCoreProblemGroup;
import org.gradle.api.problems.internal.InternalProblem;
import org.gradle.api.problems.internal.InternalProblems;
import org.gradle.api.problems.internal.ResolutionFailureDataSpec;
import org.gradle.internal.component.resolution.failure.ReportableAsProblem;
import org.gradle.internal.component.resolution.failure.interfaces.ResolutionFailure;
import org.gradle.internal.deprecation.Documentation;
import org.gradle.internal.exceptions.Contextual;
import org.gradle.internal.exceptions.ResolutionProvider;
import org.gradle.internal.exceptions.StyledException;
import org.gradle.util.internal.TextUtil;
import org.jspecify.annotations.Nullable;

@Contextual
public abstract class AbstractResolutionFailureException
extends StyledException
implements ResolutionProvider,
ReportableAsProblem {
    private static final Logger LOGGER = Logging.getLogger(AbstractResolutionFailureException.class);
    private final ImmutableList<String> resolutions;
    protected final ResolutionFailure failure;

    public AbstractResolutionFailureException(String message, ResolutionFailure failure, List<String> resolutions) {
        this(message, failure, resolutions, null);
    }

    public AbstractResolutionFailureException(String message, ResolutionFailure failure, List<String> resolutions, @Nullable Throwable cause) {
        super(message, cause);
        this.failure = failure;
        this.resolutions = ImmutableList.copyOf(resolutions);
        LOGGER.info("Variant Selection Exception: {} caused by Resolution Failure: {}", (Object)this.getClass().getName(), (Object)this.getFailure().getClass().getName());
    }

    public abstract ResolutionFailure getFailure();

    public ImmutableList<String> getResolutions() {
        return this.resolutions;
    }

    public AbstractResolutionFailureException reportAsProblem(InternalProblems problemsService) {
        InternalProblem problem = problemsService.getInternalReporter().internalCreate(builder -> {
            ResolutionFailureProblemId problemId = this.getFailure().getProblemId();
            builder.id(TextUtil.screamingSnakeToKebabCase((String)problemId.name()), problemId.getDisplayName(), GradleCoreProblemGroup.variantResolution()).contextualLabel(this.getMessage()).documentedAt((DocLink)Documentation.userManual((String)"variant_model", (String)"sec:variant-select-errors")).severity(Severity.ERROR).additionalDataInternal(ResolutionFailureDataSpec.class, data -> data.from(this.getFailure()));
        });
        problemsService.getInternalReporter().report((Problem)problem);
        return this;
    }
}

