#include <ctype.h>
#include <fcntl.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>

#include <util.h>

#include "liblif.h"

#define LIF_MAXNAMELEN	10

void
lif_parse_filename(char *str, char **volname, char **filename)
{
	char *p1, *p2;
	p1 = strtok_r(str, ":", &p2);
	if (p2 == NULL) {
		*volname = NULL;
		*filename = p1;
	} else {
		*volname = p1;
		if (*p2 == '\0')
			*filename = NULL;
		else
			*filename = p2;
	}
}

void
lif_makename(char *str, char *lname)
{
	char *cp;
	int i;

	if ((cp = strrchr(str, '/')) != NULL)
		str = ++cp;
	for (i = 0; i < LIF_MAXNAMELEN; i++) {
		if (islower(*str))
			lname[i] = toupper(*str);
		else if (isalnum(*str) || *str == '_')
			lname[i] = *str;
		else
			break;
		str++;
	}
	for ( ; i < LIF_MAXNAMELEN; i++)
		lname[i] = '\0';
}

int
lif_checkname(const char *str)
{
	int i;

	for (i = 0; i < LIF_MAXNAMELEN; i++) {
		if (*str == '\0')
			return (0);
		if (islower(*str))
			return (-1);
		else if (!(isalnum(*str) || *str == '_'))
			return (-1);
		str++;
	}
	return (0);
}

int
lif_lookup(int fd, const char *filename, struct lifdir *rld)
{
	u_int8_t buf[SECTOR_SIZE];
	struct lifvol lv;
	struct lifdir *ld;
	int blocknum;
	int i;

	lseek(fd, 0, SEEK_SET);
	if (read(fd, &lv, sizeof(struct lifvol)) != sizeof(struct lifvol))
		return (-1);

	blocknum =  htobe32(lv.lv_dirstart);
	for (i=0; i<htobe32(lv.lv_dirsize); i++) {

		if ((i % (SECTOR_SIZE/sizeof(struct lifdir))) == 0) {
			lif_block_read(fd, blocknum++, buf);
			ld = (struct lifdir *)buf;
		}

		if (be16toh(ld->ld_type) == 0)
			continue;	/* deleted file */
		if (be16toh(ld->ld_type) == 0xffff)
			return (-1);	/* directory end */
		if (strncmp(filename, ld->ld_name, 10) == 0) {
			*rld = *ld;
			return (i);
		}
		ld++;
	}
	return (-1);
}

int
lif_openvol(char *volname, int flags)
{
	struct stat fs;
	int fd;

	if (volname == NULL)
		return (-1);

	if (stat(volname, &fs) < 0)
		return (-1);

	switch (fs.st_mode & S_IFMT) {
	case S_IFCHR:
		fd = opendisk(volname, flags, NULL, 0, 0);
		break;
	case S_IFREG:
		fd = open(volname, flags);
		break;
	default:
		return (-1);
	}
	return (fd);
}
